/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.beans.ConstructorProperties;
import org.neo4j.kernel.info.LockingTransaction;

public final class WaitingThread
extends LockingTransaction {
    private static final long serialVersionUID = 1L;
    private final boolean writeLock;
    private final long threadId;
    private final String threadName;
    private final long waitingSince;

    public static WaitingThread create(String transaction, int readCount, int writeCount, Thread thread, long waitingSince, boolean isWriteLock) {
        return new WaitingThread(transaction, readCount, writeCount, thread.getId(), thread.getName(), waitingSince, isWriteLock);
    }

    @ConstructorProperties(value={"transaction", "readCount", "writeCount", "threadId", "threadName", "waitingSince", "waitingOnWriteLock"})
    public WaitingThread(String transaction, int readCount, int writeCount, long threadId, String threadName, long waitingSince, boolean writeLock) {
        super(transaction, readCount, writeCount);
        this.threadId = threadId;
        this.threadName = threadName;
        this.waitingSince = waitingSince;
        this.writeLock = writeLock;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\"").append(this.getThreadName()).append("\" ").append(" (").append(this.getTransaction()).append(") ").append("[tid=").append(this.getThreadId()).append("(").append(this.getReadCount()).append("r,").append(this.getWriteCount()).append("w ),").append(this.isWaitingOnWriteLock() ? "Write" : "Read").append("Lock]");
        return builder.toString();
    }

    public boolean isWaitingOnReadLock() {
        return !this.writeLock;
    }

    public boolean isWaitingOnWriteLock() {
        return this.writeLock;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getWaitingSince() {
        return this.waitingSince;
    }
}

