/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.logging.ClassicLoggingService;
import org.neo4j.kernel.logging.LogbackService;
import org.neo4j.kernel.logging.Logging;

public class LogbackWeakDependency {
    public static final Function<Config, Logging> DEFAULT_TO_CLASSIC = new Function<Config, Logging>(){

        @Override
        public Logging apply(Config config) {
            return new ClassicLoggingService(config);
        }
    };
    public static final Function<Config, Object> NEW_LOGGER_CONTEXT = new Function<Config, Object>(){

        @Override
        public Object apply(Config from) {
            try {
                return Class.forName(LogbackWeakDependency.LOGGER_CONTEXT_CLASS_NAME).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw Exceptions.launderedException(e);
            }
        }
    };
    public static final Function<Config, Object> STATIC_LOGGER_CONTEXT = new Function<Config, Object>(){

        @Override
        public Object apply(Config config) {
            try {
                Class<?> loggerBinderClass = Class.forName(LogbackWeakDependency.LOGGER_BINDER_CLASS_NAME);
                Object loggerBinder = loggerBinderClass.getDeclaredMethod("getSingleton", new Class[0]).invoke(null, new Object[0]);
                return loggerBinder.getClass().getDeclaredMethod("getLoggerFactory", new Class[0]).invoke(loggerBinder, new Object[0]);
            }
            catch (Exception e) {
                throw Exceptions.launderedException(e);
            }
        }
    };
    private static final String LOGGER_CONTEXT_CLASS_NAME = "ch.qos.logback.classic.LoggerContext";
    private static final String LOGGER_BINDER_CLASS_NAME = "org.slf4j.impl.StaticLoggerBinder";

    public static Function<Config, Logging> logbackOrDefaultToClassic() {
        return new Function<Config, Logging>(){

            @Override
            public Logging apply(Config config) {
                return new LogbackWeakDependency().tryLoadLogbackService(config, DEFAULT_TO_CLASSIC);
            }
        };
    }

    public Logging tryLoadLogbackService(Config config, Function<Config, Object> loggerContextGetter, Function<Config, Logging> otherwiseDefaultTo) {
        try {
            if (this.logbackIsOnClasspath()) {
                return this.newLogbackService(config, loggerContextGetter.apply(config));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return otherwiseDefaultTo.apply(config);
    }

    public Logging tryLoadLogbackService(Config config, Function<Config, Logging> otherwiseDefaultTo) {
        return this.tryLoadLogbackService(config, STATIC_LOGGER_CONTEXT, otherwiseDefaultTo);
    }

    private Logging newLogbackService(Config config, Object loggerContext) throws Exception {
        Class<?> loggerContextClass = Class.forName(LOGGER_CONTEXT_CLASS_NAME);
        return (Logging)LogbackService.class.getConstructor(Config.class, loggerContextClass, String.class).newInstance(config, loggerContext, config.get(InternalAbstractGraphDatabase.Configuration.log_configuration_file));
    }

    private boolean logbackIsOnClasspath() {
        try {
            this.getClass().getClassLoader().loadClass(LOGGER_CONTEXT_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

