/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.lang.reflect.Field;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import sun.misc.Unsafe;

public class OffHeapLongArray
implements LongArray {
    private final long address;
    private final long length;
    private static final Unsafe unsafe = OffHeapLongArray.getUnsafe();

    public OffHeapLongArray(long length) {
        this.length = length;
        this.address = unsafe.allocateMemory(length << 3);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long get(long index) {
        return unsafe.getLong(this.addressOf(index));
    }

    private long addressOf(long index) {
        if (index < 0L || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException("Requested index " + index + ", but length is " + this.length);
        }
        return this.address + (index << 3);
    }

    @Override
    public void set(long index, long value) {
        unsafe.putLong(this.addressOf(index), value);
    }

    @Override
    public void setAll(long value) {
        if (this.isByteUniform(value)) {
            unsafe.setMemory(this.address, this.length << 3, (byte)value);
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                unsafe.putLong(adr, value);
                ++i;
                adr += 8L;
            }
        }
    }

    private boolean isByteUniform(long value) {
        byte any = 0;
        for (int i = 0; i < 8; ++i) {
            byte test = (byte)(value >>> 8 * i);
            if (i == 0) {
                any = test;
                continue;
            }
            if (test == any) continue;
            return false;
        }
        return true;
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        long fromAddress = this.addressOf(fromIndex);
        long toAddress = this.addressOf(toIndex);
        int i = 0;
        while (i < numberOfEntries) {
            long fromValue = unsafe.getLong(fromAddress);
            long toValue = unsafe.getLong(toAddress);
            unsafe.putLong(fromAddress, toValue);
            unsafe.putLong(toAddress, fromValue);
            ++i;
            fromAddress += 8L;
            toAddress += 8L;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            return (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

