/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccess;

public abstract class BatchingRecordAccess<KEY, RECORD, ADDITIONAL>
implements RecordAccess<KEY, RECORD, ADDITIONAL> {
    private final List<BatchingRecordProxy<KEY, RECORD, ADDITIONAL>> proxies = new ArrayList<BatchingRecordProxy<KEY, RECORD, ADDITIONAL>>();

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> getOrLoad(KEY key, ADDITIONAL additionalData) {
        throw new UnsupportedOperationException("We only support creations here");
    }

    @Override
    public RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> create(KEY key, ADDITIONAL additionalData) {
        RECORD record = this.createRecord(key, additionalData);
        BatchingRecordProxy proxy = new BatchingRecordProxy(key, record, additionalData);
        this.proxies.add(proxy);
        return proxy;
    }

    protected abstract RECORD createRecord(KEY var1, ADDITIONAL var2);

    public Iterable<RECORD> records() {
        return new IterableWrapper<RECORD, BatchingRecordProxy<KEY, RECORD, ADDITIONAL>>(this.proxies){

            @Override
            protected RECORD underlyingObjectToObject(BatchingRecordProxy<KEY, RECORD, ADDITIONAL> object) {
                return object.record;
            }
        };
    }

    @Override
    public void close() {
    }

    public static class BatchingRecordProxy<KEY, RECORD, ADDITIONAL>
    implements RecordAccess.RecordProxy<KEY, RECORD, ADDITIONAL> {
        private final KEY key;
        private final RECORD record;
        private final ADDITIONAL additional;

        private BatchingRecordProxy(KEY key, RECORD record, ADDITIONAL additional) {
            this.key = key;
            this.record = record;
            this.additional = additional;
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forChangingData() {
            return this.record;
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            return this.record;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additional;
        }

        @Override
        public RECORD getBefore() {
            return null;
        }
    }
}

