/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ChannelReusingFileSystemAbstraction
extends LifecycleAdapter
implements FileSystemAbstraction {
    private final FileSystemAbstraction delegate;
    private final Map<File, KeepAliveStoreChannel> openChannels = new HashMap<File, KeepAliveStoreChannel>();

    public ChannelReusingFileSystemAbstraction(FileSystemAbstraction delegate) {
        this.delegate = delegate;
    }

    @Override
    public StoreChannel open(File fileName, String mode) throws IOException {
        KeepAliveStoreChannel channel = this.openChannels.get(fileName);
        if (channel == null) {
            channel = new KeepAliveStoreChannel(this.delegate.open(fileName, mode));
            this.openChannels.put(fileName, channel);
        }
        return channel;
    }

    @Override
    public void shutdown() throws Throwable {
        for (KeepAliveStoreChannel channel : this.openChannels.values()) {
            channel.closeForReal();
        }
        this.openChannels.clear();
    }

    @Override
    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        throw new UnsupportedOperationException("Just checking if this is used");
    }

    @Override
    public InputStream openAsInputStream(File fileName) throws IOException {
        throw new UnsupportedOperationException("Just checking if this is used");
    }

    @Override
    public Reader openAsReader(File fileName, String encoding) throws IOException {
        throw new UnsupportedOperationException("Just checking if this is used");
    }

    @Override
    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        throw new UnsupportedOperationException("Just checking if this is used");
    }

    @Override
    public org.neo4j.kernel.impl.nioneo.store.FileLock tryLock(File fileName, StoreChannel channel) throws IOException {
        return this.delegate.tryLock(fileName, channel);
    }

    @Override
    public StoreChannel create(File fileName) throws IOException {
        return this.delegate.create(fileName);
    }

    @Override
    public boolean fileExists(File fileName) {
        return this.delegate.fileExists(fileName);
    }

    @Override
    public boolean mkdir(File fileName) {
        return this.delegate.mkdir(fileName);
    }

    @Override
    public void mkdirs(File fileName) throws IOException {
        this.delegate.mkdirs(fileName);
    }

    @Override
    public long getFileSize(File fileName) {
        return this.delegate.getFileSize(fileName);
    }

    @Override
    public boolean deleteFile(File fileName) {
        return this.delegate.deleteFile(fileName);
    }

    @Override
    public void deleteRecursively(File directory) throws IOException {
        this.delegate.deleteRecursively(directory);
    }

    @Override
    public boolean renameFile(File from, File to) throws IOException {
        return this.delegate.renameFile(from, to);
    }

    @Override
    public File[] listFiles(File directory) {
        return this.delegate.listFiles(directory);
    }

    @Override
    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.delegate.listFiles(directory, filter);
    }

    @Override
    public boolean isDirectory(File file) {
        return this.delegate.isDirectory(file);
    }

    @Override
    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.delegate.moveToDirectory(file, toDirectory);
    }

    @Override
    public void copyFile(File from, File to) throws IOException {
        this.delegate.copyFile(from, to);
    }

    @Override
    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.delegate.copyRecursively(fromDirectory, toDirectory);
    }

    @Override
    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return this.delegate.getOrCreateThirdPartyFileSystem(clazz, creator);
    }

    public static class KeepAliveStoreChannel
    implements StoreChannel {
        private final StoreChannel delegate;

        public KeepAliveStoreChannel(StoreChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }

        @Override
        public FileLock tryLock() throws IOException {
            return this.delegate.tryLock();
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
        }

        private void closeForReal() throws IOException {
            this.delegate.close();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.delegate.write(src, position);
        }

        @Override
        public void writeAll(ByteBuffer src, long position) throws IOException {
            this.write(src, position);
        }

        @Override
        public void writeAll(ByteBuffer src) throws IOException {
            this.write(src);
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return this.delegate.map(mode, position, size);
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            return this.delegate.read(dst, position);
        }

        @Override
        public void force(boolean metaData) throws IOException {
        }

        @Override
        public StoreChannel position(long newPosition) throws IOException {
            return this.delegate.position(newPosition);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public StoreChannel truncate(long size) throws IOException {
            return this.delegate.truncate(size);
        }

        @Override
        public long position() throws IOException {
            return this.delegate.position();
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.delegate.read(dsts);
        }

        @Override
        public long size() throws IOException {
            return this.delegate.size();
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.delegate.write(srcs);
        }
    }
}

