/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class TailoredWindowPoolFactory
implements WindowPoolFactory {
    private final WindowPoolFactory defaultFactory;
    private final Map<String, WindowPoolFactory> overrides = new HashMap<String, WindowPoolFactory>();

    public TailoredWindowPoolFactory(WindowPoolFactory defaultFactory) {
        this.defaultFactory = defaultFactory;
    }

    public void override(String storeNamePart, WindowPoolFactory override) {
        this.overrides.put("neostore" + storeNamePart, override);
    }

    @Override
    public WindowPool create(File storageFileName, int recordSize, StoreChannel fileChannel, Config configuration, StringLogger log, int numberOfReservedLowIds) {
        WindowPoolFactory override = this.overrides.get(storageFileName.getName());
        WindowPoolFactory factory = override != null ? override : this.defaultFactory;
        return factory.create(storageFileName, recordSize, fileChannel, configuration, log, numberOfReservedLowIds);
    }
}

