/**
 * Copyright (c) 2002-2015 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.util.Collection;

import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;

/**
 * Visits the {@link org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord
 * record} of a {@link Command}.
 */
public interface CommandRecordVisitor
{
    void visitNode( NodeRecord record );

    void visitRelationship( RelationshipRecord record );

    void visitRelationshipGroup( RelationshipGroupRecord record );

    void visitProperty( PropertyRecord record );

    void visitRelationshipTypeToken( RelationshipTypeTokenRecord record );

    void visitLabelToken( LabelTokenRecord record );

    void visitPropertyKeyToken( PropertyKeyTokenRecord record );

    void visitNeoStore( NeoStoreRecord record );

    void visitSchemaRule( Collection<DynamicRecord> records );
}
