/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.reflect.Array;

public abstract class ArrayUtil {
    public static final ArrayEquality DEFAULT_ARRAY_EQUALITY = new ArrayEquality(){

        @Override
        public boolean typeEquals(Class<?> firstType, Class<?> otherType) {
            return firstType == otherType;
        }

        @Override
        public boolean itemEquals(Object lhs, Object rhs) {
            return lhs == rhs || lhs != null && lhs.equals(rhs);
        }
    };

    public static String toString(Object array) {
        assert (array.getClass().isArray()) : array + " is not an array";
        StringBuilder result = new StringBuilder();
        String separator = "[";
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            result.append(separator).append(Array.get(array, i));
            separator = ", ";
        }
        return result.append(']').toString();
    }

    public static int hashCode(Object array) {
        int length;
        assert (array.getClass().isArray()) : array + " is not an array";
        int result = length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            result = 31 * result + Array.get(array, i).hashCode();
        }
        return result;
    }

    public static boolean equals(Object firstArray, Object otherArray) {
        return ArrayUtil.equals(firstArray, otherArray, DEFAULT_ARRAY_EQUALITY);
    }

    public static boolean equals(Object firstArray, Object otherArray, ArrayEquality equality) {
        int length;
        assert (firstArray.getClass().isArray()) : firstArray + " is not an array";
        assert (otherArray.getClass().isArray()) : otherArray + " is not an array";
        if (equality.typeEquals(firstArray.getClass(), otherArray.getClass()) && (length = Array.getLength(firstArray)) == Array.getLength(otherArray)) {
            for (int i = 0; i < length; ++i) {
                if (equality.itemEquals(Array.get(firstArray, i), Array.get(otherArray, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object clone(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).clone();
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        throw new IllegalArgumentException("Not an array type: " + array.getClass());
    }

    public static boolean approximatelyEqual(double[] that, double[] other, double tolerance) {
        if (that == other) {
            return true;
        }
        if (null == that || null == other) {
            return false;
        }
        if (that.length != other.length) {
            return false;
        }
        for (int i = 0; i < that.length; ++i) {
            if (!(Math.abs(other[i] - that[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    private ArrayUtil() {
    }

    public static interface ArrayEquality {
        public boolean typeEquals(Class<?> var1, Class<?> var2);

        public boolean itemEquals(Object var1, Object var2);
    }
}

