/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.FloatingPointNumberProperty;

abstract class IntegralNumberProperty
extends DefinedProperty {
    IntegralNumberProperty(int propertyKeyId) {
        super(propertyKeyId);
    }

    abstract long longValue();

    @Override
    final int valueHash() {
        long value = this.longValue();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public final boolean valueEquals(Object other) {
        if (other instanceof Number) {
            Number that = (Number)other;
            if (other instanceof Double || other instanceof Float) {
                return IntegralNumberProperty.numbersEqual(that.doubleValue(), this.longValue());
            }
            return this.longValue() == that.longValue();
        }
        return false;
    }

    @Override
    final boolean hasEqualValue(DefinedProperty other) {
        if (other instanceof IntegralNumberProperty) {
            IntegralNumberProperty that = (IntegralNumberProperty)other;
            return this.longValue() == that.longValue();
        }
        if (other instanceof FloatingPointNumberProperty) {
            FloatingPointNumberProperty that = (FloatingPointNumberProperty)other;
            return IntegralNumberProperty.numbersEqual(that.doubleValue(), this.longValue());
        }
        return false;
    }
}

