/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.state.PropertyContainerState;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.util.DiffSets;

public final class NodeState
extends PropertyContainerState {
    private DiffSets<Integer> labelDiffSets;
    private RelationshipChangesForNode relationshipsAdded;
    private RelationshipChangesForNode relationshipsRemoved;
    private Set<DiffSets<Long>> indexDiffs;

    public NodeState(long id) {
        super(id);
    }

    public DiffSets<Integer> labelDiffSets() {
        if (null == this.labelDiffSets) {
            this.labelDiffSets = new DiffSets();
        }
        return this.labelDiffSets;
    }

    public void addRelationship(long relId, int typeId, Direction direction) {
        if (!this.hasAddedRelationships()) {
            this.relationshipsAdded = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD);
        }
        this.relationshipsAdded.addRelationship(relId, typeId, direction);
    }

    public void removeRelationship(long relId, int typeId, Direction direction) {
        if (this.hasAddedRelationships() && this.relationshipsAdded.removeRelationship(relId, typeId, direction)) {
            return;
        }
        if (!this.hasRemovedRelationships()) {
            this.relationshipsRemoved = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.REMOVE);
        }
        this.relationshipsRemoved.addRelationship(relId, typeId, direction);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.relationshipsAdded != null) {
            this.relationshipsAdded.clear();
        }
        if (this.relationshipsRemoved != null) {
            this.relationshipsRemoved.clear();
        }
        if (this.labelDiffSets != null) {
            this.labelDiffSets.clear();
        }
        if (this.indexDiffs != null) {
            this.indexDiffs.clear();
        }
    }

    public PrimitiveLongIterator augmentRelationships(Direction direction, PrimitiveLongIterator rels) {
        if (this.hasAddedRelationships()) {
            return this.relationshipsAdded.augmentRelationships(direction, rels);
        }
        return rels;
    }

    public PrimitiveLongIterator augmentRelationships(Direction direction, int[] types, PrimitiveLongIterator rels) {
        if (this.hasAddedRelationships()) {
            return this.relationshipsAdded.augmentRelationships(direction, types, rels);
        }
        return rels;
    }

    public int augmentDegree(Direction direction, int degree) {
        if (this.hasAddedRelationships()) {
            degree = this.relationshipsAdded.augmentDegree(direction, degree);
        }
        if (this.hasRemovedRelationships()) {
            degree = this.relationshipsRemoved.augmentDegree(direction, degree);
        }
        return degree;
    }

    public int augmentDegree(Direction direction, int degree, int typeId) {
        if (this.hasAddedRelationships()) {
            degree = this.relationshipsAdded.augmentDegree(direction, degree, typeId);
        }
        if (this.hasRemovedRelationships()) {
            degree = this.relationshipsRemoved.augmentDegree(direction, degree, typeId);
        }
        return degree;
    }

    public void accept(Visitor visitor) {
        super.accept(visitor);
        if (this.labelDiffSets != null) {
            visitor.visitLabelChanges(this.getId(), this.labelDiffSets.getAdded().iterator(), this.labelDiffSets.getRemoved().iterator());
        }
    }

    private boolean hasAddedRelationships() {
        return this.relationshipsAdded != null;
    }

    private boolean hasRemovedRelationships() {
        return this.relationshipsRemoved != null;
    }

    public PrimitiveIntIterator relationshipTypes() {
        if (this.hasAddedRelationships()) {
            return this.relationshipsAdded.relationshipTypes();
        }
        return PrimitiveIntCollections.emptyIterator();
    }

    public boolean hasLabelChanges() {
        return this.labelDiffSets != null;
    }

    public void addIndexDiff(DiffSets<Long> diff) {
        if (this.indexDiffs == null) {
            this.indexDiffs = Collections.newSetFromMap(new IdentityHashMap());
        }
        this.indexDiffs.add(diff);
    }

    public void removeIndexDiff(DiffSets<Long> diff) {
        if (this.indexDiffs != null) {
            this.indexDiffs.remove(diff);
        }
    }

    public void clearIndexDiffs(long nodeId) {
        if (this.indexDiffs != null) {
            for (DiffSets<Long> diff : this.indexDiffs) {
                if (diff.getAdded().contains(nodeId)) {
                    diff.remove(nodeId);
                    continue;
                }
                if (!diff.getRemoved().contains(nodeId)) continue;
                diff.add(nodeId);
            }
        }
    }

    public static interface Visitor
    extends PropertyContainerState.Visitor {
        public void visitLabelChanges(long var1, Iterator<Integer> var3, Iterator<Integer> var4);
    }
}

