/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import java.io.Serializable;
import org.neo4j.kernel.impl.util.statistics.RollingAverage;

public final class NodeLivenessData
implements Serializable {
    private static final long serialVersionUID = -8657743503560688270L;
    private final RollingAverage liveEntities;
    private final RollingAverage deadEntities;
    private long highestNodeId = 0L;
    private transient int liveEntitiesSeenInRound;
    private transient int deadEntitiesSeenInRound;

    public NodeLivenessData(RollingAverage.Parameters parameters) {
        this.liveEntities = new RollingAverage(parameters);
        this.deadEntities = new RollingAverage(parameters);
    }

    public void recordLiveEntity() {
        ++this.liveEntitiesSeenInRound;
    }

    public void recordDeadEntity() {
        ++this.deadEntitiesSeenInRound;
    }

    public void recalculate() {
        this.liveEntities.record(this.liveEntitiesSeenInRound);
        this.deadEntities.record(this.deadEntitiesSeenInRound);
        this.liveEntitiesSeenInRound = 0;
        this.deadEntitiesSeenInRound = 0;
    }

    public double liveEntitiesRatio() {
        double alive = this.liveEntities.average();
        double total = this.deadEntities.average() + alive;
        return total <= 0.0 ? 1.0 : alive / total;
    }

    public long highestNodeId() {
        return this.highestNodeId;
    }

    public void recordHighestId(long nodeId) {
        this.highestNodeId = nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLivenessData that = (NodeLivenessData)o;
        return this.highestNodeId == that.highestNodeId && this.deadEntities.equals(that.deadEntities) && this.liveEntities.equals(that.liveEntities);
    }

    public int hashCode() {
        int result = this.liveEntities.hashCode();
        result = 31 * result + this.deadEntities.hashCode();
        result = 31 * result + (int)(this.highestNodeId ^ this.highestNodeId >>> 32);
        return result;
    }
}

