/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyChainVerifier;
import org.neo4j.kernel.impl.util.ArrayMap;

abstract class ArrayBasedPrimitive
extends Primitive
implements EntityWithSizeObject {
    private volatile DefinedProperty[] properties;
    private volatile int registeredSize;
    static final Comparator<Property> PROPERTY_DATA_COMPARATOR_FOR_SORTING = new Comparator<Property>(){

        @Override
        public int compare(Property o1, Property o2) {
            return o1.propertyKeyId() - o2.propertyKeyId();
        }
    };
    static final Comparator PROPERTY_DATA_COMPARATOR_FOR_BINARY_SEARCH = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Property)o1).propertyKeyId() - (Integer)o2;
        }
    };

    ArrayBasedPrimitive(boolean newPrimitive) {
        super(newPrimitive);
    }

    @Override
    public void setRegisteredSize(int size) {
        this.registeredSize = size;
    }

    @Override
    public int getRegisteredSize() {
        return this.registeredSize;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        int size = 16;
        if (this.properties != null && this.properties.length > 0) {
            size = SizeOfs.withArrayOverheadIncludingReferences(size, this.properties.length);
            for (DefinedProperty data : this.properties) {
                size += data.sizeOfObjectInBytesIncludingOverhead();
            }
        }
        return SizeOfs.withObjectOverhead(size);
    }

    @Override
    protected void setEmptyProperties() {
        this.properties = NO_PROPERTIES;
    }

    private DefinedProperty[] toPropertyArray(Collection<DefinedProperty> loadedProperties, PropertyChainVerifier chainVerifier) {
        if (loadedProperties == null || loadedProperties.size() == 0) {
            return NO_PROPERTIES;
        }
        Property[] result = new DefinedProperty[loadedProperties.size()];
        int i = 0;
        for (DefinedProperty property : loadedProperties) {
            result[i++] = property;
        }
        ArrayBasedPrimitive.sort(result);
        chainVerifier.verifySortedPropertyChain((DefinedProperty[])result, this);
        return result;
    }

    private static void sort(Property[] array) {
        Arrays.sort(array, PROPERTY_DATA_COMPARATOR_FOR_SORTING);
    }

    @Override
    protected boolean hasLoadedProperties() {
        return this.properties != null;
    }

    @Override
    protected Iterator<DefinedProperty> getCachedProperties() {
        return IteratorUtil.iterator(this.properties);
    }

    @Override
    protected PrimitiveLongIterator getCachedPropertyKeys() {
        return new PrimitiveLongIterator(){
            private final Property[] localProperties;
            private int i;
            {
                this.localProperties = ArrayBasedPrimitive.this.properties;
            }

            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.localProperties[this.i++].propertyKeyId();
            }

            public boolean hasNext() {
                return this.i < this.localProperties.length;
            }
        };
    }

    @Override
    protected Property getCachedProperty(int key) {
        DefinedProperty[] localProperties = this.properties;
        int index = Arrays.binarySearch(localProperties, key, PROPERTY_DATA_COMPARATOR_FOR_BINARY_SEARCH);
        return index < 0 ? this.noProperty(key) : localProperties[index];
    }

    protected abstract Property noProperty(int var1);

    @Override
    protected void setProperties(Iterator<DefinedProperty> properties, PropertyChainVerifier chainVerifier) {
        this.properties = this.toPropertyArray(IteratorUtil.asCollection(properties), chainVerifier);
    }

    @Override
    protected DefinedProperty getPropertyForIndex(int keyId) {
        DefinedProperty[] localProperties = this.properties;
        int index = Arrays.binarySearch(localProperties, keyId, PROPERTY_DATA_COMPARATOR_FOR_BINARY_SEARCH);
        return index < 0 ? null : localProperties[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitPropertyMaps(ArrayMap<Integer, DefinedProperty> cowPropertyAddMap, ArrayMap<Integer, DefinedProperty> cowPropertyRemoveMap, long firstProp) {
        ArrayBasedPrimitive arrayBasedPrimitive = this;
        synchronized (arrayBasedPrimitive) {
            Property existingProperty;
            int i;
            Property[] newArray = this.properties;
            if (newArray == null) {
                return;
            }
            int extraLength = 0;
            if (cowPropertyAddMap != null) {
                extraLength += cowPropertyAddMap.size();
            }
            int newArraySize = newArray.length;
            if (extraLength > 0) {
                Property[] oldArray = newArray;
                newArray = new DefinedProperty[oldArray.length + extraLength];
                System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            } else {
                newArray = (DefinedProperty[])newArray.clone();
            }
            if (cowPropertyRemoveMap != null) {
                block3: for (Integer keyIndex : cowPropertyRemoveMap.keySet()) {
                    for (i = 0; i < newArraySize; ++i) {
                        existingProperty = newArray[i];
                        if (existingProperty.propertyKeyId() != keyIndex.intValue()) continue;
                        int swapWith = --newArraySize;
                        newArray[i] = newArray[swapWith];
                        newArray[swapWith] = null;
                        continue block3;
                    }
                }
            }
            if (cowPropertyAddMap != null) {
                block5: for (DefinedProperty addedProperty : cowPropertyAddMap.values()) {
                    for (i = 0; i < newArray.length; ++i) {
                        existingProperty = newArray[i];
                        if (existingProperty != null && addedProperty.propertyKeyId() != existingProperty.propertyKeyId()) continue;
                        newArray[i] = Property.property(addedProperty.propertyKeyId(), addedProperty.value());
                        if (existingProperty != null) continue block5;
                        ++newArraySize;
                        continue block5;
                    }
                }
            }
            if (newArraySize < newArray.length) {
                Property[] compactedNewArray = new DefinedProperty[newArraySize];
                System.arraycopy(newArray, 0, compactedNewArray, 0, newArraySize);
                ArrayBasedPrimitive.sort(compactedNewArray);
                this.properties = compactedNewArray;
            } else {
                ArrayBasedPrimitive.sort(newArray);
                this.properties = newArray;
            }
        }
    }
}

