/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupStore;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class NodeFirstRelationshipStep
extends LonelyProcessingStep
implements NodeRelationshipLink.GroupVisitor {
    private final NodeStore nodeStore;
    private final RelationshipGroupStore relGroupStore;
    private final NodeRelationshipLink nodeRelationshipLink;
    private long nextGroupId = -1L;

    public NodeFirstRelationshipStep(StageControl control, int batchSize, NodeStore nodeStore, RelationshipGroupStore relGroupStore, NodeRelationshipLink nodeRelationshipLink) {
        super(control, "LINKER", batchSize);
        this.nodeStore = nodeStore;
        this.relGroupStore = relGroupStore;
        this.nodeRelationshipLink = nodeRelationshipLink;
    }

    @Override
    protected void process() {
        long highId = this.nodeStore.getHighestPossibleIdInUse();
        NodeRecord heavilyReusedRecord = new NodeRecord(-1L);
        for (long nodeId = highId; nodeId >= 0L; --nodeId) {
            long firstRel = this.nodeRelationshipLink.getFirstRel(nodeId, this);
            if (firstRel == -1L) continue;
            NodeRecord record = this.nodeStore.getRecord(nodeId, heavilyReusedRecord);
            record.setNextRel(firstRel);
            if (this.nodeRelationshipLink.isDense(nodeId)) {
                record.setDense(true);
            }
            this.nodeStore.updateRecord(record);
            this.itemProcessed();
        }
        this.nodeStore.flushAll();
    }

    @Override
    public long visit(long nodeId, int type, long next, long out, long in, long loop) {
        long id = this.nextGroupId != -1L ? this.nextGroupId : this.relGroupStore.nextId();
        this.nextGroupId = -1L;
        RelationshipGroupRecord groupRecord = new RelationshipGroupRecord(id, type);
        groupRecord.setInUse(true);
        groupRecord.setFirstOut(out);
        groupRecord.setFirstIn(in);
        groupRecord.setFirstLoop(loop);
        groupRecord.setOwningNode(nodeId);
        if (next != -1L) {
            this.nextGroupId = this.relGroupStore.nextId();
            groupRecord.setNext(this.nextGroupId);
        }
        this.relGroupStore.updateRecord(groupRecord);
        return id;
    }
}

