/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.AbstractUniquenessFilter;
import org.neo4j.graphdb.traversal.PrimitiveTypeFetcher;
import org.neo4j.graphdb.traversal.TraversalBranch;

class LevelUnique
extends AbstractUniquenessFilter {
    private final PrimitiveIntObjectMap<PrimitiveLongSet> idsPerLevel = Primitive.intObjectMap();

    LevelUnique(PrimitiveTypeFetcher type) {
        super(type);
    }

    @Override
    public boolean check(TraversalBranch branch) {
        int level = branch.length();
        PrimitiveLongSet levelIds = (PrimitiveLongSet)this.idsPerLevel.get(level);
        if (levelIds == null) {
            levelIds = Primitive.longSet();
            this.idsPerLevel.put(level, (Object)levelIds);
        }
        return levelIds.add(this.type.getId(branch));
    }

    @Override
    public boolean checkFull(Path path) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

