/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.impl.nioneo.store.AbstractRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;

public abstract class TokenRecord
extends AbstractRecord {
    private int nameId = Record.NO_NEXT_BLOCK.intValue();
    private final List<DynamicRecord> nameRecords = new ArrayList<DynamicRecord>();
    private boolean isLight;

    TokenRecord(int id) {
        super(id);
    }

    void setIsLight(boolean status) {
        this.isLight = status;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public int getNameId() {
        return this.nameId;
    }

    public void setNameId(int blockId) {
        this.nameId = blockId;
    }

    public Collection<DynamicRecord> getNameRecords() {
        return this.nameRecords;
    }

    public void addNameRecord(DynamicRecord record) {
        this.nameRecords.add(record);
    }

    public void addNameRecords(Iterable<DynamicRecord> records) {
        for (DynamicRecord record : records) {
            this.addNameRecord(record);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.simpleName() + "[");
        buf.append(this.getId()).append(",").append(this.inUse() ? "in" : "no").append(" use");
        buf.append(",nameId=").append(this.nameId);
        this.additionalToString(buf);
        if (!this.isLight) {
            for (DynamicRecord dyn : this.nameRecords) {
                buf.append(',').append(dyn);
            }
        }
        return buf.append(']').toString();
    }

    protected abstract String simpleName();

    protected void additionalToString(StringBuilder buf) {
    }
}

