/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v19;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;

public class Legacy19NodeStoreReader
implements LegacyNodeStoreReader {
    public static final String FROM_VERSION = "NodeStore v0.A.0";
    public static final int RECORD_SIZE = 9;
    private final StoreChannel fileChannel;
    private final long maxId;

    public Legacy19NodeStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 9L;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public Iterator<NodeRecord> iterator() throws IOException {
        return new PrefetchingIterator<NodeRecord>(){
            long id = 0L;
            ByteBuffer buffer = ByteBuffer.allocateDirect(9);

            @Override
            protected NodeRecord fetchNextOrNull() {
                NodeRecord nodeRecord = null;
                while (nodeRecord == null && this.id <= Legacy19NodeStoreReader.this.maxId) {
                    boolean inUse;
                    Legacy19Store.readIntoBuffer(Legacy19NodeStoreReader.this.fileChannel, this.buffer, 9);
                    long inUseByte = this.buffer.get();
                    boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
                    if (inUse) {
                        long nextRel = Legacy19Store.getUnsignedInt(this.buffer);
                        long relModifier = (inUseByte & 0xEL) << 31;
                        long nextProp = Legacy19Store.getUnsignedInt(this.buffer);
                        long propModifier = (inUseByte & 0xF0L) << 28;
                        nodeRecord = new NodeRecord(this.id, false, Legacy19Store.longFromIntAndMod(nextRel, relModifier), Legacy19Store.longFromIntAndMod(nextProp, propModifier));
                        nodeRecord.setInUse(inUse);
                    } else {
                        nodeRecord = null;
                    }
                    ++this.id;
                }
                return nodeRecord;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

