/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserDispatcher;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV4;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV5;

public class DefaultLogEntryParserFactory
implements LogEntryParserFactory {
    private byte lastVersion;
    private LogEntryParserDispatcher lastParserDispatcher;

    @Override
    public LogEntryParserDispatcher newInstance(byte logVersion) {
        if (logVersion == this.lastVersion && this.lastParserDispatcher != null) {
            return this.lastParserDispatcher;
        }
        this.lastVersion = logVersion;
        this.lastParserDispatcher = this.figureOutCorrectDispatcher(logVersion);
        return this.lastParserDispatcher;
    }

    private LogEntryParserDispatcher figureOutCorrectDispatcher(byte logVersion) {
        switch (logVersion) {
            case 2: {
                return new LogEntryParserDispatcher((LogEntryParser[])LogEntryParsersV2.values());
            }
            case 3: {
                return new LogEntryParserDispatcher((LogEntryParser[])LogEntryParsersV3.values());
            }
            case 4: {
                return new LogEntryParserDispatcher((LogEntryParser[])LogEntryParsersV4.values());
            }
            case 5: {
                return new LogEntryParserDispatcher((LogEntryParser[])LogEntryParsersV5.values());
            }
        }
        throw new IllegalStateException("Unsupported log version format " + logVersion);
    }
}

