/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.tooling.GlobalGraphOperations;

public class CreateAndDeleteNodesIT {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingALabelUsingAValidIdentifierShouldSucceed() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Transaction tx = beansAPI.beginTx();
        try {
            Node myNode = beansAPI.createNode();
            myNode.setProperty("Name", (Object)"Bob");
            myNode.createRelationshipTo(beansAPI.createNode(), (RelationshipType)RelTypes.ASD);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Transaction tx2 = beansAPI.beginTx();
        try {
            for (Relationship r : GlobalGraphOperations.at((GraphDatabaseService)beansAPI).getAllRelationships()) {
                r.delete();
            }
            for (Node n : GlobalGraphOperations.at((GraphDatabaseService)beansAPI).getAllNodes()) {
                n.delete();
            }
            tx2.success();
        }
        finally {
            tx2.finish();
        }
    }

    static enum RelTypes implements RelationshipType
    {
        ASD;

    }
}

