/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.test.ImpermanentDatabaseRule;

public class IndexingAcceptanceTest {
    public static final String LONG_STRING = "a long string that has to be stored in dynamic records";
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private Label LABEL1 = DynamicLabel.label((String)"LABEL1");
    private Label LABEL2 = DynamicLabel.label((String)"LABEL2");
    private Label LABEL3 = DynamicLabel.label((String)"LABEL3");

    @Test
    public void shouldInterpretPropertyAsChangedEvenIfPropertyMovesFromOneRecordToAnother() throws Exception {
        IndexDefinition indexDefinition;
        Node myNode;
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        long smallValue = 10L;
        long bigValue = 0x4000000000000000L;
        try (Transaction tx = beansAPI.beginTx();){
            myNode = beansAPI.createNode(new Label[]{this.LABEL1});
            myNode.setProperty("pad0", (Object)true);
            myNode.setProperty("pad1", (Object)true);
            myNode.setProperty("pad2", (Object)true);
            myNode.setProperty("key", (Object)smallValue);
            tx.success();
        }
        try (Transaction tx = beansAPI.beginTx();){
            indexDefinition = beansAPI.schema().indexFor(this.LABEL1).on("key").create();
            tx.success();
        }
        Neo4jMatchers.waitForIndex((GraphDatabaseService)beansAPI, indexDefinition);
        tx = beansAPI.beginTx();
        var8_5 = null;
        try {
            myNode.setProperty("key", (Object)bigValue);
            tx.success();
        }
        catch (Throwable throwable) {
            var8_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var8_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "key", bigValue, (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "key", smallValue, (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldUseDynamicPropertiesToIndexANodeWhenAddedAlongsideExistingPropertiesInASeparateTransaction() throws Exception {
        Node myNode;
        IndexDefinition indexDefinition;
        long id;
        GraphDatabaseAPI beansAPI = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = beansAPI.beginTx();){
            Node myNode2 = beansAPI.createNode();
            id = myNode2.getId();
            myNode2.setProperty("key0", (Object)true);
            myNode2.setProperty("key1", (Object)true);
            tx.success();
        }
        try (Transaction tx = beansAPI.beginTx();){
            indexDefinition = beansAPI.schema().indexFor(this.LABEL1).on("key2").create();
            tx.success();
        }
        Neo4jMatchers.waitForIndex((GraphDatabaseService)beansAPI, indexDefinition);
        tx = beansAPI.beginTx();
        var6_4 = null;
        try {
            myNode = beansAPI.getNodeById(id);
            myNode.addLabel(this.LABEL1);
            myNode.setProperty("key2", (Object)LONG_STRING);
            myNode.setProperty("key3", (Object)LONG_STRING);
            tx.success();
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var6_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasProperty("key2").withValue(LONG_STRING)));
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasProperty("key3").withValue(LONG_STRING)));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "key2", LONG_STRING, (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void searchingForNodeByPropertyShouldWorkWithoutIndex() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node myNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1);
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void searchingUsesIndexWhenItExists() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node myNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1);
        Neo4jMatchers.createIndex(beansAPI, this.LABEL1, "name");
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyAtTheSameTime() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node myNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1, this.LABEL2);
        Neo4jMatchers.createIndex(beansAPI, this.LABEL1, "name");
        Neo4jMatchers.createIndex(beansAPI, this.LABEL2, "name");
        Neo4jMatchers.createIndex(beansAPI, this.LABEL3, "name");
        try (Transaction tx = beansAPI.beginTx();){
            myNode.removeLabel(this.LABEL1);
            myNode.addLabel(this.LABEL3);
            myNode.setProperty("name", (Object)"Einstein");
            tx.success();
        }
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasProperty("name").withValue("Einstein")));
        Assert.assertThat(this.labels(myNode), Neo4jMatchers.containsOnly(this.LABEL2, this.LABEL3));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Einstein", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Hawking", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Einstein", beansAPI), Neo4jMatchers.containsOnly(myNode));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Hawking", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Einstein", beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyMultipleTimesAllAtOnce() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node myNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1, this.LABEL2);
        Neo4jMatchers.createIndex(beansAPI, this.LABEL1, "name");
        Neo4jMatchers.createIndex(beansAPI, this.LABEL2, "name");
        Neo4jMatchers.createIndex(beansAPI, this.LABEL3, "name");
        try (Transaction tx = beansAPI.beginTx();){
            myNode.addLabel(this.LABEL3);
            myNode.setProperty("name", (Object)"Einstein");
            myNode.removeLabel(this.LABEL1);
            myNode.setProperty("name", (Object)"Feynman");
            tx.success();
        }
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasProperty("name").withValue("Feynman")));
        Assert.assertThat(this.labels(myNode), Neo4jMatchers.containsOnly(this.LABEL2, this.LABEL3));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Einstein", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Feynman", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Hawking", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Einstein", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Feynman", beansAPI), Neo4jMatchers.containsOnly(myNode));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Hawking", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Einstein", beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Feynman", beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void searchingByLabelAndPropertyReturnsEmptyWhenMissingLabelOrProperty() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", beansAPI), Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldSeeIndexUpdatesWhenQueryingOutsideTransaction() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Neo4jMatchers.createIndex(beansAPI, this.LABEL1, "name");
        Node firstNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Mattias", beansAPI), Neo4jMatchers.containsOnly(firstNode));
        Node secondNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Taylor"}), this.LABEL1);
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Taylor", beansAPI), Neo4jMatchers.containsOnly(secondNode));
    }

    @Test
    public void createdNodeShouldShowUpWithinTransaction() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Neo4jMatchers.createIndex(beansAPI, this.LABEL1, "name");
        Transaction tx = beansAPI.beginTx();
        Node firstNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        long sizeBeforeDelete = IteratorUtil.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        firstNode.delete();
        long sizeAfterDelete = IteratorUtil.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void deletedNodeShouldShowUpWithinTransaction() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Neo4jMatchers.createIndex(beansAPI, this.LABEL1, "name");
        Node firstNode = this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Transaction tx = beansAPI.beginTx();
        long sizeBeforeDelete = IteratorUtil.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        firstNode.delete();
        long sizeAfterDelete = IteratorUtil.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void createdNodeShouldShowUpInIndexQuery() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Neo4jMatchers.createIndex(beansAPI, this.LABEL1, "name");
        this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Transaction tx = beansAPI.beginTx();
        long sizeBeforeDelete = IteratorUtil.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        this.createNode(beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        long sizeAfterDelete = IteratorUtil.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)2L));
    }

    @Test
    public void shouldBeAbleToQuerySupportedPropertyTypes() throws Exception {
        String property = "name";
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Neo4jMatchers.createIndex(db, this.LABEL1, property);
        this.assertCanCreateAndFind(db, this.LABEL1, property, "A String");
        this.assertCanCreateAndFind(db, this.LABEL1, property, true);
        this.assertCanCreateAndFind(db, this.LABEL1, property, false);
        this.assertCanCreateAndFind(db, this.LABEL1, property, (byte)56);
        this.assertCanCreateAndFind(db, this.LABEL1, property, Character.valueOf('z'));
        this.assertCanCreateAndFind(db, this.LABEL1, property, (short)12);
        this.assertCanCreateAndFind(db, this.LABEL1, property, 12);
        this.assertCanCreateAndFind(db, this.LABEL1, property, 12L);
        this.assertCanCreateAndFind(db, this.LABEL1, property, Float.valueOf(12.0f));
        this.assertCanCreateAndFind(db, this.LABEL1, property, 12.0);
        this.assertCanCreateAndFind(db, this.LABEL1, property, new String[]{"A String"});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new boolean[]{true});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Boolean[]{false});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new byte[]{56});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Byte[]{(byte)57});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new char[]{'a'});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Character[]{Character.valueOf('b')});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new short[]{12});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Short[]{(short)13});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new int[]{14});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Integer[]{15});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new long[]{16L});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Long[]{17L});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new float[]{18.0f});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Float[]{Float.valueOf(19.0f)});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new double[]{20.0});
        this.assertCanCreateAndFind(db, this.LABEL1, property, new Double[]{21.0});
    }

    @Test
    public void shouldRetrieveMultipleNodesWithSameValueFromIndex() throws Exception {
        Node node2;
        Node node1;
        GraphDatabaseService graph = this.dbRule.getGraphDatabaseService();
        Neo4jMatchers.createIndex(graph, this.LABEL1, "name");
        try (Transaction tx = graph.beginTx();){
            node1 = graph.createNode(new Label[]{this.LABEL1});
            node1.setProperty("name", (Object)"Stefan");
            node2 = graph.createNode(new Label[]{this.LABEL1});
            node2.setProperty("name", (Object)"Stefan");
            tx.success();
        }
        tx = graph.beginTx();
        var5_3 = null;
        try {
            ResourceIterator result = graph.findNodes(this.LABEL1, "name", (Object)"Stefan");
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node2}), (Object)IteratorUtil.asSet((Iterator)result));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(expected=MultipleFoundException.class)
    public void shouldThrowWhenMulitpleResultsForSingleNode() throws Exception {
        GraphDatabaseService graph = this.dbRule.getGraphDatabaseService();
        Neo4jMatchers.createIndex(graph, this.LABEL1, "name");
        try (Transaction tx = graph.beginTx();){
            Node node1 = graph.createNode(new Label[]{this.LABEL1});
            node1.setProperty("name", (Object)"Stefan");
            Node node2 = graph.createNode(new Label[]{this.LABEL1});
            node2.setProperty("name", (Object)"Stefan");
            tx.success();
        }
        tx = graph.beginTx();
        var5_3 = null;
        try {
            graph.findNode(this.LABEL1, "name", (Object)"Stefan");
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldAddIndexedPropertyToNodeWithDynamicLabels() {
        long nodeId;
        int indexesCount = 20;
        String labelPrefix = "foo";
        String propertyKeyPrefix = "bar";
        String propertyValuePrefix = "baz";
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        for (int i = 0; i < indexesCount; ++i) {
            Neo4jMatchers.createIndex(db, DynamicLabel.label((String)(labelPrefix + i)), propertyKeyPrefix + i);
        }
        try (Transaction tx = db.beginTx();){
            nodeId = db.createNode().getId();
            tx.success();
        }
        tx = db.beginTx();
        var9_9 = null;
        try {
            Node node = db.getNodeById(nodeId);
            for (int i = 0; i < indexesCount; ++i) {
                node.addLabel(DynamicLabel.label((String)(labelPrefix + i)));
                node.setProperty(propertyKeyPrefix + i, (Object)(propertyValuePrefix + i));
            }
            tx.success();
        }
        catch (Throwable x2) {
            var9_9 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var9_9.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var9_9 = null;
        try {
            for (int i = 0; i < indexesCount; ++i) {
                Label label = DynamicLabel.label((String)(labelPrefix + i));
                String key = propertyKeyPrefix + i;
                String value = propertyValuePrefix + i;
                ResourceIterable nodes = db.findNodesByLabelAndProperty(label, key, (Object)value);
                Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)nodes));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var9_9.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertCanCreateAndFind(GraphDatabaseService db, Label label, String propertyKey, Object value) {
        Node created = this.createNode(db, MapUtil.map((Object[])new Object[]{propertyKey, value}), label);
        try (Transaction tx = db.beginTx();){
            Node found = db.findNode(label, propertyKey, value);
            Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)created));
            found.delete();
            tx.success();
        }
    }

    private Node createNode(GraphDatabaseService beansAPI, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = beansAPI.beginTx();){
            Node node = beansAPI.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Neo4jMatchers.Deferred<Label> labels(final Node myNode) {
        return new Neo4jMatchers.Deferred<Label>(this.dbRule.getGraphDatabaseService()){

            @Override
            protected Iterable<Label> manifest() {
                return myNode.getLabels();
            }
        };
    }
}

