/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.test.impl.EphemeralIdGenerator;
import org.neo4j.tooling.GlobalGraphOperations;

public class LabelsAcceptanceTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void shouldInsertLabelsWithoutDuplicatingThem() throws Exception {
        final Node node = this.dbRule.executeAndCommit(new Function<GraphDatabaseService, Node>(){

            public Node apply(GraphDatabaseService db) {
                return db.createNode();
            }
        });
        this.dbRule.executeAndCommit(new Function<GraphDatabaseService, Void>(){

            public Void apply(GraphDatabaseService db) {
                node.addLabel(DynamicLabel.label((String)"FOOBAR"));
                return null;
            }
        });
        this.dbRule.executeAndCommit(new Function<GraphDatabaseService, Void>(){

            public Void apply(GraphDatabaseService db) {
                node.addLabel(DynamicLabel.label((String)"BAZQUX"));
                return null;
            }
        });
        this.dbRule.executeAndCommit(new Function<GraphDatabaseService, Void>(){

            public Void apply(GraphDatabaseService db) {
                for (Label label : node.getLabels()) {
                    node.removeLabel(label);
                }
                node.addLabel(DynamicLabel.label((String)"BAZQUX"));
                return null;
            }
        });
        List<Label> labels = this.dbRule.executeAndCommit(new Function<GraphDatabaseService, List<Label>>(){

            public List<Label> apply(GraphDatabaseService db) {
                ArrayList<Label> labels = new ArrayList<Label>();
                for (Label label : node.getLabels()) {
                    labels.add(label);
                }
                return labels;
            }
        });
        Assert.assertEquals((String)labels.toString(), (long)1L, (long)labels.size());
        Assert.assertEquals((Object)"BAZQUX", (Object)labels.get(0).name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingALabelUsingAValidIdentifierShouldSucceed() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node myNode = null;
        Transaction tx = beansAPI.beginTx();
        try {
            myNode = beansAPI.createNode();
            myNode.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((String)"Label should have been added to node", (Object)myNode, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabel(Labels.MY_LABEL)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingALabelUsingAnInvalidIdentifierShouldFail() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Transaction tx = beansAPI.beginTx();
        try {
            beansAPI.createNode().addLabel(DynamicLabel.label((String)""));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ConstraintViolationException ex) {
        }
        finally {
            tx.finish();
        }
        Transaction tx2 = beansAPI.beginTx();
        try {
            beansAPI.createNode().addLabel(DynamicLabel.label(null));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ConstraintViolationException ex) {
        }
        finally {
            tx2.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingALabelThatAlreadyExistsBehavesAsNoOp() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node myNode = null;
        Transaction tx = beansAPI.beginTx();
        try {
            myNode = beansAPI.createNode();
            myNode.addLabel((Label)Labels.MY_LABEL);
            myNode.addLabel((Label)Labels.MY_LABEL);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((String)"Label should have been added to node", (Object)myNode, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabel(Labels.MY_LABEL)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void oversteppingMaxNumberOfLabelsShouldFailGracefully() throws Exception {
        GraphDatabaseService beansAPI = this.beansAPIWithNoMoreLabelIds();
        Transaction tx = beansAPI.beginTx();
        try {
            beansAPI.createNode().addLabel((Label)Labels.MY_LABEL);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (ConstraintViolationException constraintViolationException) {
        }
        finally {
            tx.finish();
        }
        beansAPI.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removingCommittedLabel() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        Node myNode = this.createNode(beansAPI, label);
        Transaction tx = beansAPI.beginTx();
        try {
            myNode.removeLabel((Label)label);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabel(label))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNodeWithLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Node node = null;
        Transaction tx = db.beginTx();
        try {
            node = db.createNode((Label[])Labels.values());
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(db, Neo4jMatchers.hasLabels(IteratorUtil.asEnumNameSet(Labels.class))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removingNonExistentLabel() throws Exception {
        Node myNode;
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        Transaction tx = beansAPI.beginTx();
        try {
            myNode = beansAPI.createNode();
            myNode.removeLabel((Label)label);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabel(label))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removingExistingLabelFromUnlabeledNode() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        this.createNode(beansAPI, label);
        Node myNode = this.createNode(beansAPI, new Label[0]);
        Transaction tx = beansAPI.beginTx();
        try {
            myNode.removeLabel((Label)label);
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((Object)myNode, (Matcher)Matchers.not(Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabel(label))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removingUncommittedLabel() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Labels label = Labels.MY_LABEL;
        Transaction tx = beansAPI.beginTx();
        try {
            Node myNode = beansAPI.createNode();
            myNode.addLabel((Label)label);
            myNode.removeLabel((Label)label);
            Assert.assertFalse((boolean)myNode.hasLabel((Label)label));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToListLabelsForANode() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Transaction tx = beansAPI.beginTx();
        Node node = null;
        Set expected = IteratorUtil.asSet((Object[])new String[]{Labels.MY_LABEL.name(), Labels.MY_OTHER_LABEL.name()});
        try {
            node = beansAPI.createNode();
            for (String label : expected) {
                node.addLabel(DynamicLabel.label((String)label));
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasLabels(expected)));
    }

    @Test
    public void shouldReturnEmptyListIfNoLabels() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node node = this.createNode(beansAPI, new Label[0]);
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasNoLabels()));
    }

    @Test
    public void getNodesWithLabelCommitted() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Transaction tx = beansAPI.beginTx();
        Node node = beansAPI.createNode();
        node.addLabel((Label)Labels.MY_LABEL);
        tx.success();
        tx.finish();
        Assert.assertThat((Object)beansAPI, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasNodes(Labels.MY_LABEL, node)));
        Assert.assertThat((Object)beansAPI, Neo4jMatchers.inTx(beansAPI, Neo4jMatchers.hasNoNodes(Labels.MY_OTHER_LABEL)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getNodesWithLabelsWithTxAddsAndRemoves() throws Exception {
        GraphDatabaseService beansAPI = this.dbRule.getGraphDatabaseService();
        Node node1 = this.createNode(beansAPI, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        Node node2 = this.createNode(beansAPI, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        Transaction tx = beansAPI.beginTx();
        Node node3 = null;
        Set nodesWithMyLabel = null;
        Set nodesWithMyOtherLabel = null;
        try {
            node3 = beansAPI.createNode(new Label[]{Labels.MY_LABEL});
            node2.removeLabel((Label)Labels.MY_LABEL);
            nodesWithMyLabel = IteratorUtil.asSet((Iterator)beansAPI.findNodes((Label)Labels.MY_LABEL));
            nodesWithMyOtherLabel = IteratorUtil.asSet((Iterator)beansAPI.findNodes((Label)Labels.MY_OTHER_LABEL));
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node3}), (Object)nodesWithMyLabel);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Node[]{node1, node2}), (Object)nodesWithMyOtherLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldListLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        GlobalGraphOperations globalOps = GlobalGraphOperations.at((GraphDatabaseService)db);
        this.createNode(db, Labels.MY_LABEL, Labels.MY_OTHER_LABEL);
        List labels = null;
        Transaction tx = db.beginTx();
        try {
            labels = Iterables.toList((Iterable)globalOps.getAllLabels());
        }
        finally {
            tx.finish();
        }
        Assert.assertEquals((long)2L, (long)labels.size());
        Assert.assertThat((Object)Iterables.map((org.neo4j.function.Function)new Function<Label, String>(){

            public String apply(Label label) {
                return label.name();
            }
        }, (Iterable)labels), (Matcher)Matchers.hasItems((Object[])new String[]{Labels.MY_LABEL.name(), Labels.MY_OTHER_LABEL.name()}));
    }

    @Test
    public void deleteAllNodesAndTheirLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Label label = DynamicLabel.label((String)"A");
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.addLabel(label);
            node.setProperty("name", (Object)"bla");
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                node.removeLabel(label);
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Transaction transaction = db.beginTx();
        Assert.assertEquals((long)0L, (long)IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()));
        transaction.finish();
    }

    @Test
    public void removingLabelDoesNotBreakPreviouslyCreatedLabelsIterator() {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Label label1 = DynamicLabel.label((String)"A");
        Label label2 = DynamicLabel.label((String)"B");
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{label1, label2});
            for (Label next : node.getLabels()) {
                node.removeLabel(next);
            }
            tx.success();
        }
    }

    @Test
    public void removingPropertyDoesNotBreakPreviouslyCreatedNodePropertyKeysIterator() {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)"Horst");
            node.setProperty("age", (Object)"72");
            Iterator iterator = node.getPropertyKeys().iterator();
            while (iterator.hasNext()) {
                node.removeProperty((String)iterator.next());
            }
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateNodeWithLotsOfLabelsAndThenRemoveMostOfThem() throws Exception {
        int i;
        Node node;
        int TOTAL_NUMBER_OF_LABELS = 200;
        int NUMBER_OF_PRESERVED_LABELS = 20;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Transaction tx = db.beginTx();
        try {
            node = db.createNode();
            for (i = 0; i < 200; ++i) {
                node.addLabel(DynamicLabel.label((String)("label:" + i)));
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = db.beginTx();
        try {
            for (i = 20; i < 200; ++i) {
                node.removeLabel(DynamicLabel.label((String)("label:" + i)));
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.dbRule.clearCache();
        Transaction transaction = db.beginTx();
        try {
            ArrayList<String> labels = new ArrayList<String>();
            for (Label label : node.getLabels()) {
                labels.add(label.name());
            }
            Assert.assertEquals((String)("labels on node: " + labels), (long)20L, (long)labels.size());
        }
        finally {
            transaction.finish();
        }
    }

    private GraphDatabaseService beansAPIWithNoMoreLabelIds() {
        final EphemeralIdGenerator.Factory idFactory = new EphemeralIdGenerator.Factory(){

            @Override
            public IdGenerator open(FileSystemAbstraction fs, File fileName, int grabSize, IdType idType, long highId) {
                switch (idType) {
                    case LABEL_TOKEN: {
                        IdGenerator generator = (IdGenerator)this.generators.get(idType);
                        if (generator == null) {
                            generator = new EphemeralIdGenerator(idType){

                                @Override
                                public long nextId() {
                                    throw new UnderlyingStorageException("Id capacity exceeded");
                                }
                            };
                            this.generators.put(idType, generator);
                        }
                        return generator;
                    }
                }
                return super.open(fs, fileName, grabSize, idType, Long.MAX_VALUE);
            }
        };
        TestGraphDatabaseFactory dbFactory = new TestGraphDatabaseFactory(){

            @Override
            protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final String storeDir, final TestGraphDatabaseFactoryState state) {
                return new GraphDatabaseBuilder.DatabaseCreator(){

                    public GraphDatabaseService newDatabase(Map<String, String> config) {
                        return new ImpermanentGraphDatabase(storeDir, config, state.databaseDependencies()){

                            protected IdGeneratorFactory createIdGeneratorFactory() {
                                return idFactory;
                            }
                        };
                    }
                };
            }
        };
        return dbFactory.newImpermanentDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNode(GraphDatabaseService db, Label ... labels) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode(labels);
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    private static enum Labels implements Label
    {
        MY_LABEL,
        MY_OTHER_LABEL;

    }
}

