/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.test.LimitedFileSystemGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class RunOutOfDiskSpaceIT {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldPropagateIOExceptions() throws Exception {
        TransactionFailureException exceptionThrown = null;
        String storeDir = this.testDirectory.absolutePath();
        LimitedFileSystemGraphDatabase db = new LimitedFileSystemGraphDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        long logVersion = ((NeoStore)db.getDependencyResolver().resolveDependency(NeoStore.class)).getCurrentLogVersion();
        db.runOutOfDiskSpaceNao();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        try {
            tx.close();
            Assert.fail((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.");
        }
        catch (TransactionFailureException e) {
            exceptionThrown = e;
        }
        Assert.assertTrue((boolean)Exceptions.contains((Throwable)exceptionThrown, (Class[])new Class[]{IOException.class}));
        db.somehowGainMoreDiskSpace();
        db.shutdown();
        Assert.assertEquals((long)logVersion, (long)new NeoStoreUtil(new File(storeDir), (FileSystemAbstraction)db.getFileSystem()).getLogVersion());
    }

    @Test
    public void shouldStopDatabaseWhenOutOfDiskSpace() throws Exception {
        TransactionFailureException errorCaught = null;
        String storeDir = this.testDirectory.absolutePath();
        LimitedFileSystemGraphDatabase db = new LimitedFileSystemGraphDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        long logVersion = ((NeoStore)db.getDependencyResolver().resolveDependency(NeoStore.class)).getCurrentLogVersion();
        db.runOutOfDiskSpaceNao();
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        try {
            tx.close();
            Assert.fail((String)"Expected tx finish to throw TransactionFailureException when filesystem is full.");
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
        try {
            db.beginTx();
            Assert.fail((String)"Expected tx begin to throw TransactionFailureException when tx manager breaks.");
        }
        catch (TransactionFailureException e) {
            errorCaught = e;
        }
        Assert.assertThat((Object)errorCaught.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(org.neo4j.kernel.api.exceptions.TransactionFailureException.class)));
        db.somehowGainMoreDiskSpace();
        db.shutdown();
        Assert.assertEquals((long)logVersion, (long)new NeoStoreUtil(new File(storeDir), (FileSystemAbstraction)db.getFileSystem()).getLogVersion());
    }
}

