/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;

public class GraphDatabaseSettingsTest {
    private static final long KiB = 1024L;
    private static final long MiB = 0x100000L;
    private static final long GiB = 0x40000000L;

    @Test
    public void mustHaveReasonableDefaultPageCacheMemorySizeInBytes() throws Exception {
        long bytes = (Long)new Config().get(GraphDatabaseSettings.pagecache_memory);
        Assert.assertThat((Object)bytes, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0x2000000L)));
        Assert.assertThat((Object)bytes, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(0x10000000000L)));
    }

    @Test
    public void pageCacheSettingMustAcceptArbitraryUserSpecifiedValue() throws Exception {
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        String name = setting.name();
        Assert.assertThat((Object)new Config(MapUtil.stringMap((String[])new String[]{name, "16384"})).get(setting), (Matcher)Matchers.is((Object)16384L));
        Assert.assertThat((Object)new Config(MapUtil.stringMap((String[])new String[]{name, "2244g"})).get(setting), (Matcher)Matchers.is((Object)2409476653056L));
    }

    @Test(expected=InvalidSettingException.class)
    public void pageCacheSettingMustRejectOverlyConstrainedMemorySetting() throws Exception {
        long pageSize = (Long)new Config().get(GraphDatabaseSettings.mapped_memory_page_size);
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        String name = setting.name();
        new Config(MapUtil.stringMap((String[])new String[]{name, "" + (pageSize * 2L - 1L)})).get(setting);
    }
}

