/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.index;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.UniqueFactory;

@Ignore
public class UniqueFactoryTest {
    @Test
    public void shouldUseConcurrentlyCreatedNode() {
        GraphDatabaseService graphdb = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        Index index = (Index)Mockito.mock(Index.class);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)graphdb.beginTx()).thenReturn((Object)tx);
        Mockito.when((Object)index.getGraphDatabase()).thenReturn((Object)graphdb);
        IndexHits getHits = (IndexHits)Mockito.mock(IndexHits.class);
        Mockito.when((Object)index.get("key1", (Object)"value1")).thenReturn((Object)getHits);
        Node createdNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)graphdb.createNode()).thenReturn((Object)createdNode);
        Node concurrentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)index.putIfAbsent((PropertyContainer)createdNode, "key1", (Object)"value1")).thenReturn((Object)concurrentNode);
        UniqueFactory.UniqueNodeFactory unique = new UniqueFactory.UniqueNodeFactory(index){

            protected void initialize(Node created, Map<String, Object> properties) {
                Assert.fail((String)"we did not create the node, so it should not be initialized");
            }
        };
        UniqueFactory.UniqueEntity node = unique.getOrCreateWithOutcome("key1", (Object)"value1");
        Assert.assertSame((Object)node.entity(), (Object)concurrentNode);
        Assert.assertFalse((boolean)node.wasCreated());
        ((Index)Mockito.verify((Object)index)).get("key1", (Object)"value1");
        ((Index)Mockito.verify((Object)index)).putIfAbsent((PropertyContainer)createdNode, "key1", (Object)"value1");
        ((GraphDatabaseService)Mockito.verify((Object)graphdb, (VerificationMode)Mockito.times((int)1))).createNode();
        ((Transaction)Mockito.verify((Object)tx)).success();
    }

    @Test
    public void shouldCreateNodeAndIndexItIfMissing() {
        GraphDatabaseService graphdb = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        Index index = (Index)Mockito.mock(Index.class);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)graphdb.beginTx()).thenReturn((Object)tx);
        Mockito.when((Object)index.getGraphDatabase()).thenReturn((Object)graphdb);
        IndexHits indexHits = (IndexHits)Mockito.mock(IndexHits.class);
        Mockito.when((Object)index.get("key1", (Object)"value1")).thenReturn((Object)indexHits);
        Node indexedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)graphdb.createNode()).thenReturn((Object)indexedNode);
        final AtomicBoolean initializeCalled = new AtomicBoolean(false);
        UniqueFactory.UniqueNodeFactory unique = new UniqueFactory.UniqueNodeFactory(index){

            protected void initialize(Node created, Map<String, Object> properties) {
                initializeCalled.set(true);
                Assert.assertEquals(Collections.singletonMap("key1", "value1"), properties);
            }
        };
        Node node = (Node)unique.getOrCreate("key1", (Object)"value1");
        Assert.assertSame((Object)node, (Object)indexedNode);
        ((Index)Mockito.verify((Object)index)).get("key1", (Object)"value1");
        ((Index)Mockito.verify((Object)index)).putIfAbsent((PropertyContainer)indexedNode, "key1", (Object)"value1");
        ((GraphDatabaseService)Mockito.verify((Object)graphdb, (VerificationMode)Mockito.times((int)1))).createNode();
        ((Transaction)Mockito.verify((Object)tx)).success();
        Assert.assertTrue((String)"Node not initialized", (boolean)initializeCalled.get());
    }

    @Test
    public void shouldCreateNodeWithOutcomeAndIndexItIfMissing() {
        GraphDatabaseService graphdb = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        Index index = (Index)Mockito.mock(Index.class);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)graphdb.beginTx()).thenReturn((Object)tx);
        Mockito.when((Object)index.getGraphDatabase()).thenReturn((Object)graphdb);
        IndexHits indexHits = (IndexHits)Mockito.mock(IndexHits.class);
        Mockito.when((Object)index.get("key1", (Object)"value1")).thenReturn((Object)indexHits);
        Node indexedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)graphdb.createNode()).thenReturn((Object)indexedNode);
        final AtomicBoolean initializeCalled = new AtomicBoolean(false);
        UniqueFactory.UniqueNodeFactory unique = new UniqueFactory.UniqueNodeFactory(index){

            protected void initialize(Node created, Map<String, Object> properties) {
                initializeCalled.set(true);
                Assert.assertEquals(Collections.singletonMap("key1", "value1"), properties);
            }
        };
        UniqueFactory.UniqueEntity node = unique.getOrCreateWithOutcome("key1", (Object)"value1");
        Assert.assertSame((Object)node.entity(), (Object)indexedNode);
        Assert.assertTrue((boolean)node.wasCreated());
        ((Index)Mockito.verify((Object)index)).get("key1", (Object)"value1");
        ((Index)Mockito.verify((Object)index)).putIfAbsent((PropertyContainer)indexedNode, "key1", (Object)"value1");
        ((GraphDatabaseService)Mockito.verify((Object)graphdb, (VerificationMode)Mockito.times((int)1))).createNode();
        ((Transaction)Mockito.verify((Object)tx)).success();
        Assert.assertTrue((String)"Node not initialized", (boolean)initializeCalled.get());
    }

    @Test
    public void shouldNotTouchTransactionsIfAlreadyInIndex() {
        GraphDatabaseService graphdb = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        Index index = (Index)Mockito.mock(Index.class);
        Mockito.when((Object)index.getGraphDatabase()).thenReturn((Object)graphdb);
        IndexHits getHits = (IndexHits)Mockito.mock(IndexHits.class);
        Mockito.when((Object)index.get("key1", (Object)"value1")).thenReturn((Object)getHits);
        Node indexedNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)getHits.getSingle()).thenReturn((Object)indexedNode);
        UniqueFactory.UniqueNodeFactory unique = new UniqueFactory.UniqueNodeFactory(index){

            protected void initialize(Node created, Map<String, Object> properties) {
                Assert.fail((String)"we did not create the node, so it should not be initialized");
            }
        };
        Node node = (Node)unique.getOrCreate("key1", (Object)"value1");
        Assert.assertSame((Object)node, (Object)indexedNode);
        ((Index)Mockito.verify((Object)index)).get("key1", (Object)"value1");
    }
}

