/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.function.Function;
import org.neo4j.io.fs.AbstractStoreChannel;
import org.neo4j.io.fs.FileLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;

public class CannedFileSystemAbstraction
implements FileSystemAbstraction {
    public static Runnable NOTHING = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final boolean fileExists;
    private final IOException cannotCreateStoreDir;
    private final IOException cannotOpenLockFile;
    private final boolean lockSuccess;
    private final Runnable onClose;
    private final StoreChannel emptyFileChannel = new AbstractStoreChannel(){

        public int read(ByteBuffer dst) throws IOException {
            return 0;
        }

        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return 0L;
        }

        public long position() throws IOException {
            return 0L;
        }

        public StoreChannel position(long newPosition) throws IOException {
            if (newPosition != 0L) {
                throw this.unsupported();
            }
            return this;
        }

        public long size() throws IOException {
            return 0L;
        }

        public StoreChannel truncate(long size) throws IOException {
            if (size != 0L) {
                throw this.unsupported();
            }
            return this;
        }

        public void force(boolean metaData) throws IOException {
        }

        public int read(ByteBuffer dst, long position) throws IOException {
            return 0;
        }

        public int write(ByteBuffer src, long position) throws IOException {
            if (position != 0L) {
                throw this.unsupported();
            }
            return 0;
        }

        public void close() throws IOException {
            CannedFileSystemAbstraction.this.onClose.run();
        }

        private IOException unsupported() {
            return new IOException("Unsupported");
        }
    };
    private static final FileLock SYMBOLIC_FILE_LOCK = new FileLock(){

        public void release() throws IOException {
        }
    };

    public static Runnable callCounter(final AtomicInteger count) {
        return new Runnable(){

            @Override
            public void run() {
                count.incrementAndGet();
            }
        };
    }

    public CannedFileSystemAbstraction(boolean fileExists, IOException cannotCreateStoreDir, IOException cannotOpenLockFile, boolean lockSuccess, Runnable onClose) {
        this.fileExists = fileExists;
        this.cannotCreateStoreDir = cannotCreateStoreDir;
        this.cannotOpenLockFile = cannotOpenLockFile;
        this.lockSuccess = lockSuccess;
        this.onClose = onClose;
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        if (this.cannotOpenLockFile != null) {
            throw this.cannotOpenLockFile;
        }
        return this.emptyFileChannel;
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public Reader openAsReader(File fileName, String encoding) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public FileLock tryLock(File fileName, StoreChannel channel) throws IOException {
        if (!this.lockSuccess) {
            throw new IOException("Unable to create lock file " + fileName);
        }
        return SYMBOLIC_FILE_LOCK;
    }

    public StoreChannel create(File fileName) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean fileExists(File fileName) {
        return this.fileExists;
    }

    public boolean mkdir(File fileName) {
        return false;
    }

    public void mkdirs(File fileName) throws IOException {
        if (this.cannotCreateStoreDir != null) {
            throw this.cannotCreateStoreDir;
        }
    }

    public long getFileSize(File fileName) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean deleteFile(File fileName) {
        throw new UnsupportedOperationException("TODO");
    }

    public void deleteRecursively(File directory) throws IOException {
    }

    public boolean renameFile(File from, File to) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isDirectory(File file) {
        return false;
    }

    public File[] listFiles(File directory) {
        return new File[0];
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return new File[0];
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public void copyFile(File file, File toDirectory) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void truncate(File path, long size) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }
}

