/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.LogMarker;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DiagnosticsLoggingTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void shouldSeeHelloWorld() {
        FakeLogger logger = new FakeLogger();
        String storeDir = this.folder.getRoot().getAbsolutePath();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setLogging(logger).newEmbeddedDatabase(storeDir);
        String messages = logger.getMessages();
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Network information"));
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Disk space on partition"));
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Local timezone"));
        db.shutdown();
    }

    @Test
    public void shouldSeePageCacheConfigurationWithDumpConfigurationEnabled() {
        FakeLogger logger = new FakeLogger();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setLogging(logger).newEmbeddedDatabaseBuilder(this.folder.getRoot().getAbsolutePath()).setConfig(GraphDatabaseSettings.dump_configuration, "true").setConfig(GraphDatabaseSettings.pagecache_memory, "4M").newGraphDatabase();
        String messages = logger.getMessages();
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Page cache size: 4 MiB"));
        db.shutdown();
    }

    private class FakeLogger
    extends StringLogger
    implements Logging {
        private final StringBuilder messages = new StringBuilder();

        private FakeLogger() {
        }

        public String getMessages() {
            return this.messages.toString();
        }

        private void appendLine(String mess) {
            this.messages.append(mess).append("\n");
        }

        protected void doDebug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.appendLine(msg);
        }

        public void info(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.appendLine(msg);
        }

        public void warn(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.appendLine(msg);
        }

        public void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
            this.appendLine(msg);
        }

        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, boolean flush) {
            this.appendLine(msg);
            source.visit((Object)new StringLogger.LineLogger(){

                public void logLine(String line) {
                    FakeLogger.this.appendLine(line);
                }
            });
        }

        public void addRotationListener(Runnable listener) {
        }

        public void flush() {
        }

        public void close() {
        }

        protected void logLine(String line) {
            this.appendLine(line);
        }

        public StringLogger getMessagesLog(Class loggingClass) {
            return this;
        }

        public ConsoleLogger getConsoleLog(Class loggingClass) {
            return new ConsoleLogger(StringLogger.SYSTEM);
        }

        public void init() throws Throwable {
        }

        public void start() throws Throwable {
        }

        public void stop() throws Throwable {
        }

        public void shutdown() throws Throwable {
        }
    }
}

