/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;

public class KernelDataTest {
    private final Collection<Kernel> kernels = new HashSet<Kernel>();
    @Rule
    public final TestRule shutDownRemainingKernels = new TestRule(){

        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    try {
                        base.evaluate();
                    }
                    finally {
                        for (Kernel kernel : KernelDataTest.this.kernels.toArray(new Kernel[KernelDataTest.this.kernels.size()])) {
                            kernel.shutdown();
                        }
                        KernelDataTest.this.kernels.clear();
                    }
                }
            };
        }
    };

    @Test
    public void shouldGenerateUniqueInstanceIdentifiers() throws Exception {
        Kernel kernel1 = new Kernel(null);
        Kernel kernel2 = new Kernel(null);
        Assert.assertNotNull((Object)kernel1.instanceId());
        Assert.assertNotNull((Object)kernel2.instanceId());
        Assert.assertFalse((boolean)kernel1.instanceId().equals(kernel2.instanceId()));
    }

    @Test
    public void shouldReuseInstanceIdentifiers() throws Exception {
        Kernel kernel = new Kernel(null);
        String instanceId = kernel.instanceId();
        kernel.shutdown();
        kernel = new Kernel(null);
        Assert.assertEquals((Object)instanceId, (Object)kernel.instanceId());
    }

    @Test
    public void shouldAllowConfigurationOfInstanceId() throws Exception {
        Kernel kernel = new Kernel("myInstance");
        Assert.assertEquals((Object)"myInstance", (Object)kernel.instanceId());
    }

    @Test
    public void shouldGenerateInstanceIdentifierWhenNullConfigured() throws Exception {
        Kernel kernel = new Kernel(null);
        Assert.assertEquals((Object)kernel.instanceId(), (Object)kernel.instanceId().trim());
        Assert.assertTrue((kernel.instanceId().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGenerateInstanceIdentifierWhenEmptyStringConfigured() throws Exception {
        Kernel kernel = new Kernel("");
        Assert.assertEquals((Object)kernel.instanceId(), (Object)kernel.instanceId().trim());
        Assert.assertTrue((kernel.instanceId().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldNotAllowMultipleInstancesWithTheSameConfiguredInstanceId() throws Exception {
        new Kernel("myInstance");
        try {
            new Kernel("myInstance");
            Assert.fail((String)"should have thrown exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"There is already a kernel started with forced_kernel_id='myInstance'.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAllowReuseOfConfiguredInstanceIdAfterShutdown() throws Exception {
        new Kernel("myInstance").shutdown();
        Kernel kernel = new Kernel("myInstance");
        Assert.assertEquals((Object)"myInstance", (Object)kernel.instanceId());
    }

    private static Map<String, String> config(String desiredId) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (desiredId != null) {
            config.put(KernelData.forced_id.name(), desiredId);
        }
        return config;
    }

    private class Kernel
    extends KernelData {
        Kernel(String desiredId) {
            super(new Config(KernelDataTest.config(desiredId)));
            KernelDataTest.this.kernels.add(this);
        }

        public Version version() {
            throw new UnsupportedOperationException();
        }

        public GraphDatabaseAPI graphDatabase() {
            throw new UnsupportedOperationException();
        }

        public void shutdown() {
            super.shutdown();
            KernelDataTest.this.kernels.remove((Object)this);
        }
    }
}

