/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.NeoStoreDataSourceRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class NeoStoreDataSourceTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)this.fs.get(), this.getClass());
    @Rule
    public NeoStoreDataSourceRule ds = new NeoStoreDataSourceRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void kernelHealthShouldBeHealedOnStart() throws Throwable {
        NeoStoreDataSource theDataSource = null;
        try {
            KernelHealth kernelHealth = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), DevNullLoggingService.DEV_NULL);
            theDataSource = this.ds.getDataSource(this.dir, (FileSystemAbstraction)this.fs.get(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), MapUtil.stringMap((String[])new String[0]), kernelHealth);
            kernelHealth.panic(new Throwable());
            theDataSource.start();
            kernelHealth.assertHealthy(Throwable.class);
        }
        finally {
            if (theDataSource != null) {
                theDataSource.stop();
                theDataSource.shutdown();
            }
        }
    }
}

