/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.Recovery;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TargetDirectory;

public class RecoveryTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final LogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(1L);
    private final TransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(5L, 0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecoverExistingData() throws Exception {
        String name = "log";
        File file = new File(this.directory.directory(), name + ".1");
        boolean logVersion = true;
        this.writeSomeData(file, new Visitor<ByteBuffer, IOException>(){

            public boolean visit(ByteBuffer buffer) throws IOException {
                LogHeaderWriter.writeLogHeader((ByteBuffer)buffer, (long)1L, (long)3L);
                buffer.clear();
                buffer.position(16);
                buffer.put((byte)2);
                buffer.putInt(23324);
                return true;
            }
        });
        LifeSupport life = new LifeSupport();
        final PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory(), name, this.fs);
        Recovery.Monitor monitor = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        try {
            life.add((Object)new Recovery(new Recovery.SPI(){

                public void forceEverything() {
                }

                public long getCurrentLogVersion() {
                    return RecoveryTest.this.logVersionRepository.getCurrentLogVersion();
                }

                public Visitor<LogVersionedStoreChannel, IOException> getRecoverer() {
                    return new Visitor<LogVersionedStoreChannel, IOException>(){

                        public boolean visit(LogVersionedStoreChannel element) throws IOException {
                            ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel(element, LogVersionBridge.NO_MORE_CHANNELS, 4096);
                            Assert.assertEquals((long)2L, (long)recoveredDataChannel.get());
                            Assert.assertEquals((long)23324L, (long)recoveredDataChannel.getInt());
                            try {
                                recoveredDataChannel.get();
                                Assert.fail((String)"There should be no more");
                            }
                            catch (ReadPastEndException readPastEndException) {
                                // empty catch block
                            }
                            return true;
                        }
                    };
                }

                public PhysicalLogVersionedStoreChannel getLogFile(long recoveryVersion) throws IOException {
                    return PhysicalLogFile.openForVersion((PhysicalLogFiles)logFiles, (FileSystemAbstraction)RecoveryTest.this.fs, (long)recoveryVersion);
                }
            }, monitor));
            life.add((Object)new PhysicalLogFile(this.fs, logFiles, 50L, this.transactionIdStore, this.logVersionRepository, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), new TransactionMetadataCache(10, 100)));
            life.start();
            InOrder order = Mockito.inOrder((Object[])new Object[]{monitor});
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryRequired(1L);
            ((Recovery.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).recoveryCompleted();
        }
        finally {
            life.shutdown();
        }
    }

    private void writeSomeData(File file, Visitor<ByteBuffer, IOException> visitor) throws IOException {
        try (StoreChannel channel = this.fs.open(file, "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            visitor.visit((Object)buffer);
            buffer.flip();
            channel.write(buffer);
        }
    }
}

