/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.lang.reflect.Array;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.PropertyConversion;

public class PropertyConversionTest {
    private static Random random;

    @Test
    public void shouldConvertStringProperty() throws Exception {
        PropertyConversionTest.assertConverts("a value");
    }

    @Test
    public void shouldConvertSmallLongProperty() throws Exception {
        PropertyConversionTest.assertConverts(1 + random.nextInt(1024));
    }

    @Test
    public void shouldConvertBigLongProperty() throws Exception {
        PropertyConversionTest.assertConverts(1L + (long)random.nextInt(1024) << 32);
    }

    @Test
    public void shouldConvertIntegerProperty() throws Exception {
        PropertyConversionTest.assertConverts(1 + random.nextInt(1024));
    }

    @Test
    public void shouldConvertCharProperty() throws Exception {
        PropertyConversionTest.assertConverts(Character.valueOf(PropertyConversionTest.randomChar()));
    }

    @Test
    public void shouldConvertShortProperty() throws Exception {
        PropertyConversionTest.assertConverts(PropertyConversionTest.randomShort());
    }

    @Test
    public void shouldConvertByteProperty() throws Exception {
        PropertyConversionTest.assertConverts(PropertyConversionTest.randomByte());
    }

    @Test
    public void shouldConvertBooleanProperty() throws Exception {
        PropertyConversionTest.assertConverts(random.nextBoolean());
    }

    @Test
    public void shouldConvertFloatProperty() throws Exception {
        PropertyConversionTest.assertConverts(Float.valueOf(1.0f + random.nextFloat()));
    }

    @Test
    public void shouldConvertDoubleProperty() throws Exception {
        PropertyConversionTest.assertConverts(1.0 + random.nextDouble());
    }

    @Test
    public void shouldConvertStringArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new String[]{"foo", "bar", "baz"});
    }

    @Test
    public void shouldNotSupportNullInArrays() throws Exception {
        for (Object[] array : new Object[][]{{null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}, {null}}) {
            try {
                PropertyConversion.convertProperty((int)17, (Object)array);
                Assert.fail((String)("Should not support nulls in " + array.getClass()));
            }
            catch (IllegalArgumentException e) {
                Assert.assertEquals((Object)"Property array value elements may not be null.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void shouldConvertLongArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new long[]{random.nextLong(), random.nextLong(), random.nextLong()});
        PropertyConversionTest.assertConverts(new Long[]{random.nextLong(), random.nextLong(), random.nextLong()});
    }

    @Test
    public void shouldConvertIntegerArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new int[]{random.nextInt(), random.nextInt(), random.nextInt()});
        PropertyConversionTest.assertConverts(new Integer[]{random.nextInt(), random.nextInt(), random.nextInt()});
    }

    @Test
    public void shouldConvertCharArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new char[]{PropertyConversionTest.randomChar(), PropertyConversionTest.randomChar(), PropertyConversionTest.randomChar()});
        PropertyConversionTest.assertConverts(new Character[]{Character.valueOf(PropertyConversionTest.randomChar()), Character.valueOf(PropertyConversionTest.randomChar()), Character.valueOf(PropertyConversionTest.randomChar())});
    }

    @Test
    public void shouldConvertShortArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new short[]{PropertyConversionTest.randomShort(), PropertyConversionTest.randomShort(), PropertyConversionTest.randomShort()});
        PropertyConversionTest.assertConverts(new Short[]{PropertyConversionTest.randomShort(), PropertyConversionTest.randomShort(), PropertyConversionTest.randomShort()});
    }

    @Test
    public void shouldConvertByteArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new byte[]{PropertyConversionTest.randomByte(), PropertyConversionTest.randomByte(), PropertyConversionTest.randomByte()});
        PropertyConversionTest.assertConverts(new Byte[]{PropertyConversionTest.randomByte(), PropertyConversionTest.randomByte(), PropertyConversionTest.randomByte()});
    }

    @Test
    public void shouldConvertBooleanArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new boolean[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean()});
        PropertyConversionTest.assertConverts(new Boolean[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean()});
    }

    @Test
    public void shouldConvertFloatArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat()});
        PropertyConversionTest.assertConverts(new Float[]{Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat()), Float.valueOf(random.nextFloat())});
    }

    @Test
    public void shouldConvertDoubleArrayProperty() throws Exception {
        PropertyConversionTest.assertConverts(new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()});
        PropertyConversionTest.assertConverts(new Double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()});
    }

    private static char randomChar() {
        return (char)(1 + random.nextInt(65534));
    }

    private static short randomShort() {
        return (short)(1 + random.nextInt(32766));
    }

    private static byte randomByte() {
        return (byte)(1 + random.nextInt(126));
    }

    @BeforeClass
    public static void randomize() {
        random = new Random();
    }

    private static void assertConverts(Object value) {
        DefinedProperty property = PropertyConversion.convertProperty((int)17, (Object)value);
        PropertyConversionTest.assertDeepEquals(value, property.value());
        Assert.assertTrue((String)("valueEquals:" + value.getClass()), (boolean)property.valueEquals(value));
        Assert.assertTrue((String)"two conversions are equal", (boolean)property.equals((Object)PropertyConversion.convertProperty((int)17, (Object)value)));
        Assert.assertEquals((String)"hashCode()", (long)property.hashCode(), (long)PropertyConversion.convertProperty((int)17, (Object)value).hashCode());
        Assert.assertFalse((String)"properties with different keys should not be equal", (boolean)property.equals((Object)PropertyConversion.convertProperty((int)666, (Object)value)));
        Assert.assertFalse((String)"properties with different values should not be equal", (boolean)property.equals((Object)PropertyConversion.convertProperty((int)17, (Object)PropertyConversionTest.another(value))));
    }

    private static void assertDeepEquals(Object expected, Object actual) {
        if (expected.getClass().isArray()) {
            Assert.assertNotNull((Object)actual);
            Assert.assertTrue((String)"is array", (boolean)actual.getClass().isArray());
            int length = Array.getLength(expected);
            if (expected instanceof Object[]) {
                if (expected instanceof String[]) {
                    Assert.assertEquals(expected.getClass(), actual.getClass());
                } else {
                    Assert.assertTrue((String)"can only compare boxed arrays of non-zero length", (length > 0 ? 1 : 0) != 0);
                }
            } else {
                Assert.assertEquals((String)"component type", expected.getClass(), actual.getClass());
            }
            Assert.assertEquals((String)"array length", (long)length, (long)Array.getLength(actual));
            for (int i = 0; i < length; ++i) {
                Assert.assertEquals((Object)Array.get(expected, i), (Object)Array.get(actual, i));
            }
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private static Object another(Object value) {
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Short) {
            return -((Short)value).shortValue();
        }
        if (value instanceof Byte) {
            return -((Byte)value).byteValue();
        }
        if (value instanceof Character) {
            return Character.valueOf(-((Character)value).charValue());
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Float) {
            return Float.valueOf(-((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        if (value instanceof String) {
            return "not " + value;
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Array.set(value, i, PropertyConversionTest.another(Array.get(value, i)));
            }
            return value;
        }
        throw new AssertionError((Object)("unexpected type: " + value.getClass().getName()));
    }
}

