/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.GraphDatabaseConfigurationMigrator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;

public class TestGraphDatabaseConfigurationMigrator {
    @Test
    public void testNoMigration() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"foo", "bar"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"foo", "bar"})));
    }

    @Test
    public void testEnableOnlineBackup() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_online_backup", "true"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"online_backup_enabled", "true", "online_backup_server", "0.0.0.0:6362-6372"})));
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"online_backup_port", "1234"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"online_backup_server", "0.0.0.0:1234"})));
    }

    @Test
    public void testUdcEnabled() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.disable", "true"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.enabled", "false"})));
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.disable", "false"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"neo4j.ext.udc.enabled", "true"})));
    }

    @Test
    public void testEnableRemoteShell() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_remote_shell", "true"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"remote_shell_enabled", "true"})));
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_remote_shell", "false"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"remote_shell_enabled", "false"})));
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"enable_remote_shell", "port=1234"}), StringLogger.DEV_NULL), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"remote_shell_enabled", "true", "remote_shell_port", "1234", "remote_shell_read_only", "false", "remote_shell_name", "shell"})));
    }

    @Test
    public void testGCRRenamedToHPC() {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        TestLogger log = new TestLogger();
        Assert.assertThat((Object)migrator.apply(MapUtil.stringMap((String[])new String[]{"cache_type", "gcr"}), (StringLogger)log), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"cache_type", "hpc"})));
        log.assertAtLeastOnce(TestLogger.LogCall.warn("'gcr' cache type has been renamed to 'hpc', High Performance Cache."));
    }

    @Test
    public void testMemoryMappingIsTotalConfiguredForAllStores() throws Exception {
        GraphDatabaseConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
        TestLogger log = new TestLogger();
        Map oldConfig = MapUtil.stringMap((String[])new String[]{"neostore.nodestore.db.mapped_memory", "12M", "neostore.propertystore.db.mapped_memory", "1G", "neostore.propertystore.db.index.mapped_memory", "1M", "neostore.propertystore.db.index.keys.mapped_memory", "13", "neostore.propertystore.db.strings.mapped_memory", "2", "neostore.propertystore.db.arrays.mapped_memory", "1", "neostore.relationshipstore.db.mapped_memory", "0"});
        Assert.assertThat(migrator.apply(oldConfig, (StringLogger)log).get(GraphDatabaseSettings.pagecache_memory.name()), (Matcher)CoreMatchers.equalTo((Object)"1074790416"));
        log.assertAtLeastOnce(TestLogger.LogCall.warn("The neostore.*.db.mapped_memory settings have been replaced by the single 'dbms.pagecache.memory'. The sum of the old configuration will be used as the value for the new setting."));
    }
}

