/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SystemOutLogging;
import org.neo4j.qa.tooling.DumpProcessInformation;
import org.neo4j.qa.tooling.DumpVmInformation;
import org.neo4j.test.EmbeddedDatabaseRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.BreakpointHandler;
import org.neo4j.test.subprocess.BreakpointTrigger;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.DebuggerDeadlockCallback;
import org.neo4j.test.subprocess.EnabledBreakpoints;
import org.neo4j.test.subprocess.ForeignBreakpoints;
import org.neo4j.test.subprocess.SubProcess;
import org.neo4j.test.subprocess.SubProcessTestRunner;

@ForeignBreakpoints(value={@ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.core.ArrayBasedPrimitive", method="setProperties"), @ForeignBreakpoints.BreakpointDef(type="org.neo4j.kernel.impl.core.NodeManager", method="getNodeIfCached")})
@RunWith(value=SubProcessTestRunner.class)
@Ignore(value="Ignored in 2.0 due to half-way refactoring moving properties into kernel API. Unignore and change appropriately when it's done")
public class TestPropertyDataRace {
    @ClassRule
    public static EmbeddedDatabaseRule database = new EmbeddedDatabaseRule();
    public static final TargetDirectory targetDir = TargetDirectory.forTest(TestPropertyDataRace.class);
    private static DebuggedThread thread;
    private static final DebuggerDeadlockCallback RESUME_THREAD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @EnabledBreakpoints(value={"enable breakpoints", "done"})
    public void readingMutatorVersusCommittingMutator() throws Exception {
        Node two;
        Node one;
        final GraphDatabaseService graphdb = database.getGraphDatabaseService();
        Transaction tx = graphdb.beginTx();
        try {
            one = graphdb.createNode();
            two = graphdb.createNode();
            one.setProperty("node", (Object)"one");
            tx.success();
        }
        finally {
            tx.finish();
        }
        this.clearCaches();
        final CountDownLatch done = new CountDownLatch(2);
        final CountDownLatch prepare = new CountDownLatch(1);
        new Thread("committing mutator"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Transaction txn = graphdb.beginTx();
                try {
                    for (String key : one.getPropertyKeys()) {
                        one.removeProperty(key);
                    }
                    TestPropertyDataRace.this.clearCaches();
                    prepare.countDown();
                    txn.success();
                }
                finally {
                    txn.finish();
                }
                txn = graphdb.beginTx();
                try {
                    two.setProperty("node", (Object)"two");
                    txn.success();
                }
                finally {
                    txn.finish();
                }
                TestPropertyDataRace.this.countDown(done);
            }
        }.start();
        new Thread("reading mutator"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Transaction txn = graphdb.beginTx();
                try {
                    while (true) {
                        try {
                            prepare.await();
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            continue;
                        }
                        break;
                    }
                    for (String key : one.getPropertyKeys()) {
                        one.removeProperty(key);
                    }
                    txn.success();
                }
                finally {
                    txn.finish();
                }
                TestPropertyDataRace.this.clearCaches();
                done.countDown();
            }
        }.start();
        if (!done.await(1L, TimeUnit.MINUTES)) {
            File dumpDirectory = targetDir.cleanDirectory("dump");
            DumpVmInformation.dumpVmInfo(dumpDirectory);
            new DumpProcessInformation((Logging)new SystemOutLogging(), dumpDirectory).doThreadDump((Predicate<String>)Predicates.stringContains((String)SubProcess.class.getSimpleName()));
            Assert.fail((String)("Test didn't complete within a reasonable time, dumping process information to " + dumpDirectory));
        }
        for (String key : two.getPropertyKeys()) {
            Assert.assertEquals((Object)"two", (Object)two.getProperty(key));
        }
    }

    @BreakpointTrigger(value="enable breakpoints")
    private void clearCaches() {
        ((Caches)database.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(Caches.class)).clear();
    }

    @BreakpointTrigger(value="done")
    private void countDown(CountDownLatch latch) {
        latch.countDown();
    }

    @BreakpointHandler(value={"enable breakpoints"})
    public static void onEnableBreakpoints(BreakPoint self, @BreakpointHandler(value={"getNodeIfCached"}) BreakPoint getNodeIfCached, @BreakpointHandler(value={"setProperties"}) BreakPoint setProperties) {
        if (getNodeIfCached.isEnabled()) {
            setProperties.enable();
            self.disable();
        } else {
            getNodeIfCached.enable();
        }
    }

    @BreakpointHandler(value={"setProperties"})
    public static void onSetProperties(BreakPoint self, DebugInterface di) {
        self.disable();
        if (thread != null) {
            thread.resume();
        }
        thread = di.thread().suspend(RESUME_THREAD);
    }

    @BreakpointHandler(value={"getNodeIfCached"})
    public static void onGetNodeIfCached(BreakPoint self, DebugInterface di) {
        self.disable();
        if (thread == null) {
            thread = di.thread().suspend(null);
        }
    }

    @BreakpointHandler(value={"done"})
    public static void onDone() {
        thread.resume();
        thread = null;
    }

    static {
        RESUME_THREAD = new DebuggerDeadlockCallback(){

            @Override
            public void deadlock(DebuggedThread thread) {
                thread.resume();
            }
        };
    }
}

