/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;

public class CountsRecordStateTest {
    @Test
    public void shouldReportDifferencesBetweenDifferentStates() throws Exception {
        CountsRecordState oracle = new CountsRecordState();
        CountsRecordState victim = new CountsRecordState();
        oracle.incrementNodeCount(17, 5L);
        victim.incrementNodeCount(17, 3L);
        oracle.incrementNodeCount(12, 9L);
        victim.incrementNodeCount(12, 9L);
        oracle.incrementRelationshipCount(1, 2, 3, 19L);
        victim.incrementRelationshipCount(1, 2, 3, 22L);
        oracle.incrementRelationshipCount(1, 4, 3, 25L);
        victim.incrementRelationshipCount(1, 4, 3, 25L);
        Set differences = IteratorUtil.asSet((Iterable)oracle.verify((CountsVisitor.Visitable)victim));
        Assert.assertEquals((Object)differences, (Object)IteratorUtil.asSet((Object[])new CountsRecordState.Difference[]{new CountsRecordState.Difference((CountsKey)CountsKeyFactory.nodeKey((int)17), 0L, 5L, 0L, 3L), new CountsRecordState.Difference((CountsKey)CountsKeyFactory.relationshipKey((int)1, (int)2, (int)3), 0L, 19L, 0L, 22L)}));
    }

    @Test
    public void shouldNotReportAnythingForEqualStates() throws Exception {
        CountsRecordState oracle = new CountsRecordState();
        CountsRecordState victim = new CountsRecordState();
        oracle.incrementNodeCount(17, 5L);
        victim.incrementNodeCount(17, 5L);
        oracle.incrementNodeCount(12, 9L);
        victim.incrementNodeCount(12, 9L);
        oracle.incrementRelationshipCount(1, 4, 3, 25L);
        victim.incrementRelationshipCount(1, 4, 3, 25L);
        List differences = oracle.verify((CountsVisitor.Visitable)victim);
        Assert.assertTrue((String)differences.toString(), (boolean)differences.isEmpty());
    }
}

