/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.ImpermanentGraphDatabase;

public class KernelTest {
    @Test
    public void shouldNotAllowCreationOfConstraintsWhenInHA() throws Exception {
        FakeHaDatabase db = new FakeHaDatabase();
        ThreadToStatementContextBridge stmtBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        try (Transaction ignored = db.beginTx();){
            Statement statement = stmtBridge.instance();
            try {
                statement.schemaWriteOperations().uniquenessConstraintCreate(1, 1);
                Assert.fail((String)"expected exception here");
            }
            catch (InvalidTransactionTypeKernelException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"HA"));
            }
        }
        db.shutdown();
    }

    class FakeHaDatabase
    extends ImpermanentGraphDatabase {
        FakeHaDatabase() {
        }

        public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
            throw new InvalidTransactionTypeKernelException("Creation or deletion of constraints is not possible while running in a HA cluster. In order to do that, please restart in non-HA mode and propagate the database copy to all slaves");
        }
    }
}

