/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.File;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.test.EphemeralFileSystemRule;

public class LegacyIndexApplierTest {
    @Rule
    public final LifeRule life = new LifeRule(true);
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldOnlyCreateOneApplierPerProvider() throws Exception {
        Map names = MapUtil.genericMap((Object[])new Object[]{"first", 0, "second", 1});
        Map keys = MapUtil.genericMap((Object[])new Object[]{"key", 0});
        String applierName = "test-applier";
        IndexConfigStore config = this.newIndexConfigStore(names, applierName);
        LegacyIndexApplierLookup applierLookup = (LegacyIndexApplierLookup)Mockito.mock(LegacyIndexApplierLookup.class);
        Mockito.when((Object)applierLookup.newApplier(Matchers.anyString(), Matchers.anyBoolean())).thenReturn(Mockito.mock(NeoCommandHandler.class));
        try (LegacyIndexApplier applier = new LegacyIndexApplier(config, applierLookup, IdOrderingQueue.BYPASS, 1L, TransactionApplicationMode.INTERNAL);){
            IndexDefineCommand definitions = LegacyIndexApplierTest.definitions(names, keys);
            applier.visitIndexDefineCommand(definitions);
            applier.visitIndexAddNodeCommand(LegacyIndexApplierTest.addNodeToIndex(definitions, "first"));
            applier.visitIndexAddNodeCommand(LegacyIndexApplierTest.addNodeToIndex(definitions, "second"));
            applier.visitIndexAddRelationshipCommand(LegacyIndexApplierTest.addRelationshipToIndex(definitions, "second"));
            applier.apply();
        }
        ((LegacyIndexApplierLookup)Mockito.verify((Object)applierLookup, (VerificationMode)Mockito.times((int)1))).newApplier((String)Matchers.eq((Object)applierName), Matchers.anyBoolean());
    }

    private static IndexCommand.AddRelationshipCommand addRelationshipToIndex(IndexDefineCommand definitions, String indexName) {
        IndexCommand.AddRelationshipCommand command = new IndexCommand.AddRelationshipCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), 0L, 0, null, 1L, 2L);
        return command;
    }

    private static IndexCommand.AddNodeCommand addNodeToIndex(IndexDefineCommand definitions, String indexName) {
        IndexCommand.AddNodeCommand command = new IndexCommand.AddNodeCommand();
        command.init(definitions.getOrAssignIndexNameId(indexName), 0L, 0, null);
        return command;
    }

    private static IndexDefineCommand definitions(Map<String, Integer> names, Map<String, Integer> keys) {
        IndexDefineCommand definitions = new IndexDefineCommand();
        definitions.init(names, keys);
        return definitions;
    }

    private IndexConfigStore newIndexConfigStore(Map<String, Integer> names, String providerName) {
        File dir = new File("conf");
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(dir);
        IndexConfigStore store = this.life.add(new IndexConfigStore(dir, (FileSystemAbstraction)fileSystem));
        for (Map.Entry<String, Integer> name : names.entrySet()) {
            store.set(Node.class, name.getKey(), MapUtil.stringMap((String[])new String[]{"provider", providerName}));
            store.set(Relationship.class, name.getKey(), MapUtil.stringMap((String[])new String[]{"provider", providerName}));
        }
        return store;
    }
}

