/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.test.ImpermanentDatabaseRule;

public class SchemaLoggingIT {
    private final TestLogging logging = new TestLogging();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule(this.logging);

    @Test
    public void shouldLogUserReadableLabelAndPropertyNames() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        String labelName = "User";
        String property = "name";
        this.createIndex(db, labelName, property);
        this.logging.getMessagesLog(IndexPopulationJob.class).assertExactly(TestLogger.LogCall.info("Index population started: [:User(name) [provider: {key=in-memory-index, version=1.0}]]"), TestLogger.LogCall.info("Index population completed. Index is now online: [:User(name) [provider: {key=in-memory-index, version=1.0}]]"));
    }

    private void createIndex(GraphDatabaseAPI db, String labelName, String property) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(DynamicLabel.label((String)labelName)).on(property).create();
            tx.success();
        }
        tx = db.beginTx();
        var5_5 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

