/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.test.DoubleLatch;

public class IndexSamplingJobTrackerTest {
    private final IndexSamplingConfig config = (IndexSamplingConfig)Mockito.mock(IndexSamplingConfig.class);

    @Test
    public void shouldNotRunASampleJobWhichIsAlreadyRunning() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)2);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final AtomicInteger count = new AtomicInteger(0);
        Assert.assertTrue((boolean)jobTracker.canExecuteMoreSamplingJobs());
        IndexSamplingJob job = new IndexSamplingJob(){
            private final IndexDescriptor descriptor = new IndexDescriptor(1, 2);

            public void run() {
                count.incrementAndGet();
                latch.awaitStart();
                latch.finish();
            }

            public IndexDescriptor descriptor() {
                return this.descriptor;
            }
        };
        jobTracker.scheduleSamplingJob(job);
        jobTracker.scheduleSamplingJob(job);
        latch.start();
        latch.awaitFinish();
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void shouldNotAcceptMoreJobsThanAllowed() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)1);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        final IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final DoubleLatch waitingLatch = new DoubleLatch();
        Assert.assertTrue((boolean)jobTracker.canExecuteMoreSamplingJobs());
        jobTracker.scheduleSamplingJob(new IndexSamplingJob(){
            private final IndexDescriptor descriptor = new IndexDescriptor(1, 2);

            public void run() {
                latch.start();
                latch.awaitFinish();
            }

            public IndexDescriptor descriptor() {
                return this.descriptor;
            }
        });
        latch.awaitStart();
        Assert.assertFalse((boolean)jobTracker.canExecuteMoreSamplingJobs());
        final AtomicBoolean waiting = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                waiting.set(true);
                waitingLatch.start();
                jobTracker.waitUntilCanExecuteMoreSamplingJobs();
                waiting.set(false);
                waitingLatch.finish();
            }
        }).start();
        waitingLatch.awaitStart();
        Assert.assertTrue((boolean)waiting.get());
        latch.finish();
        waitingLatch.awaitFinish();
        Assert.assertFalse((boolean)waiting.get());
        while (!jobTracker.canExecuteMoreSamplingJobs()) {
            Thread.yield();
        }
    }

    @Test(timeout=5000L)
    public void shouldAcceptNewJobWhenRunningJobFinishes() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)1);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        final IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final AtomicBoolean lastJobExecuted = new AtomicBoolean();
        jobTracker.scheduleSamplingJob(new IndexSamplingJob(){

            public IndexDescriptor descriptor() {
                return new IndexDescriptor(1, 1);
            }

            public void run() {
                latch.awaitStart();
            }
        });
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                jobTracker.waitUntilCanExecuteMoreSamplingJobs();
                jobTracker.scheduleSamplingJob(new IndexSamplingJob(){

                    public IndexDescriptor descriptor() {
                        return new IndexDescriptor(2, 2);
                    }

                    public void run() {
                        lastJobExecuted.set(true);
                        latch.finish();
                    }
                });
            }
        });
        Assert.assertFalse((boolean)jobTracker.canExecuteMoreSamplingJobs());
        latch.start();
        latch.awaitFinish();
        Assert.assertTrue((boolean)lastJobExecuted.get());
    }

    @Test(timeout=5000L)
    public void shouldDoNothingWhenUsedAfterBeingStopped() {
        JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, scheduler);
        jobTracker.stopAndAwaitAllJobs();
        jobTracker.scheduleSamplingJob((IndexSamplingJob)Mockito.mock(IndexSamplingJob.class));
        Mockito.verifyZeroInteractions((Object[])new Object[]{scheduler});
    }

    @Test(timeout=5000L)
    public void shouldNotAllowNewJobsAfterBeingStopped() {
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)Mockito.mock(JobScheduler.class));
        jobTracker.stopAndAwaitAllJobs();
        Assert.assertFalse((boolean)jobTracker.canExecuteMoreSamplingJobs());
    }

    @Test(timeout=5000L)
    public void shouldStopAndWaitForAllJobsToFinish() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)2);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        final IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        WaitingIndexSamplingJob job1 = new WaitingIndexSamplingJob(new IndexDescriptor(1, 1), latch1);
        WaitingIndexSamplingJob job2 = new WaitingIndexSamplingJob(new IndexDescriptor(2, 2), latch1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job1);
        jobTracker.scheduleSamplingJob((IndexSamplingJob)job2);
        Future<?> stopping = Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                latch2.countDown();
                jobTracker.stopAndAwaitAllJobs();
            }
        });
        latch2.await();
        Assert.assertFalse((boolean)stopping.isDone());
        latch1.countDown();
        stopping.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)stopping.isDone());
        Assert.assertNull(stopping.get());
        Assert.assertTrue((boolean)job1.executed);
        Assert.assertTrue((boolean)job2.executed);
    }

    private static class WaitingIndexSamplingJob
    implements IndexSamplingJob {
        final IndexDescriptor descriptor;
        final CountDownLatch latch;
        volatile boolean executed;

        WaitingIndexSamplingJob(IndexDescriptor descriptor, CountDownLatch latch) {
            this.descriptor = descriptor;
            this.latch = latch;
        }

        public IndexDescriptor descriptor() {
            return this.descriptor;
        }

        public void run() {
            try {
                this.latch.await();
                this.executed = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

