/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import com.sun.xml.internal.xsom.impl.scd.Iterators;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.txstate.ReadableTxState;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.state.AugmentWithLocalStateExpandCursor;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.kernel.impl.util.ExpandTestUtils;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.kernel.impl.util.register.NeoRegisters;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class AugmentWithLocalStateExpandCursorTest {
    private final NeoRegister.NodeRegister nodeId = NeoRegisters.newNodeRegister((long)1L);
    private final Register.ObjectRegister<int[]> relTypes = Registers.newObjectRegister((Object)new int[]{1});
    private final Register.ObjectRegister<Direction> expandDirection = Registers.newObjectRegister((Object)Direction.INCOMING);
    private final NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
    private final NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
    private final Register.ObjectRegister<Direction> direction = Registers.newObjectRegister();
    private final NeoRegister.NodeRegister startNodeId = NeoRegisters.newNodeRegister();
    private final NeoRegister.NodeRegister neighborNodeId = NeoRegisters.newNodeRegister();

    @Test
    public void shouldRemoveRemovedRels() throws Exception {
        StoreReadLayer store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        ReadableTxState txState = (ReadableTxState)Mockito.mock(ReadableTxState.class);
        Mockito.when((Object)txState.relationshipIsDeletedInThisTx(3L)).thenReturn((Object)true);
        this.givenStoredRels(store, ExpandTestUtils.row(3L, 2, Direction.INCOMING, 1L, 1L), ExpandTestUtils.row(4L, 2, Direction.INCOMING, 1L, 1L));
        AugmentWithLocalStateExpandCursor cursor = this.newAugmentingExpandCursor(store, txState);
        MatcherAssert.assertThat(ExpandTestUtils.rows((Cursor)cursor, this.relId, this.relType, this.direction, this.startNodeId, this.neighborNodeId), (Matcher)CoreMatchers.equalTo(Arrays.asList(ExpandTestUtils.row(4L, 2, Direction.INCOMING, 1L, 1L))));
    }

    @Test
    public void shouldMixInAddedRels() throws Exception {
        StoreReadLayer store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        ReadableTxState txState = (ReadableTxState)Mockito.mock(ReadableTxState.class);
        long node = this.nodeId.read();
        this.givenTxRels(txState, node, ExpandTestUtils.row(1337L, 2, Direction.INCOMING, node, 3L), ExpandTestUtils.row(1338L, 2, Direction.INCOMING, node, 3L));
        this.givenStoredRels(store, ExpandTestUtils.row(2L, 2, Direction.INCOMING, node, 2L), ExpandTestUtils.row(3L, 2, Direction.INCOMING, node, 2L));
        AugmentWithLocalStateExpandCursor cursor = this.newAugmentingExpandCursor(store, txState);
        MatcherAssert.assertThat(ExpandTestUtils.rows((Cursor)cursor, this.relId, this.relType, this.direction, this.startNodeId, this.neighborNodeId), (Matcher)CoreMatchers.equalTo(Arrays.asList(ExpandTestUtils.row(2L, 2, Direction.INCOMING, 1L, 2L), ExpandTestUtils.row(3L, 2, Direction.INCOMING, 1L, 2L), ExpandTestUtils.row(1337L, 2, Direction.INCOMING, 1L, 3L), ExpandTestUtils.row(1338L, 2, Direction.INCOMING, 1L, 3L))));
    }

    @Test
    public void shouldIterateTxOnlyNodes() throws Exception {
        StoreReadLayer store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        ReadableTxState txState = (ReadableTxState)Mockito.mock(ReadableTxState.class);
        long node = this.nodeId.read();
        this.givenTxRels(txState, node, ExpandTestUtils.row(1337L, 2, Direction.INCOMING, node, 3L), ExpandTestUtils.row(1338L, 2, Direction.INCOMING, node, 3L));
        this.givenStoredRels(store, new ExpandTestUtils.Row[0]);
        Mockito.when((Object)txState.nodeIsAddedInThisTx(node)).thenReturn((Object)true);
        AugmentWithLocalStateExpandCursor cursor = this.newAugmentingExpandCursor(store, txState);
        MatcherAssert.assertThat(ExpandTestUtils.rows((Cursor)cursor, this.relId, this.relType, this.direction, this.startNodeId, this.neighborNodeId), (Matcher)CoreMatchers.equalTo(Arrays.asList(ExpandTestUtils.row(1337L, 2, Direction.INCOMING, 1L, 3L), ExpandTestUtils.row(1338L, 2, Direction.INCOMING, 1L, 3L))));
    }

    private AugmentWithLocalStateExpandCursor newAugmentingExpandCursor(StoreReadLayer store, ReadableTxState txState) {
        return new AugmentWithLocalStateExpandCursor(store, txState, Cursors.countDownCursor((int)1), (NeoRegister.Node.In)this.nodeId, this.relTypes, this.expandDirection, (NeoRegister.Relationship.Out)this.relId, (NeoRegister.RelType.Out)this.relType, this.direction, (NeoRegister.Node.Out)this.startNodeId, (NeoRegister.Node.Out)this.neighborNodeId);
    }

    private void givenTxRels(ReadableTxState state, long nodeId, ExpandTestUtils.Row ... rows) throws Exception {
        HashSet<Long> relIds = new HashSet<Long>();
        for (ExpandTestUtils.Row row : rows) {
            relIds.add(row.relId);
            final ExpandTestUtils.Row r = row;
            Mockito.when((Object)state.relationshipVisit(Mockito.eq((long)row.relId), (RelationshipVisitor)Mockito.any(RelationshipVisitor.class))).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    if (r.direction == Direction.INCOMING) {
                        ((RelationshipVisitor)invocation.getArguments()[1]).visit(r.relId, r.type, r.neighborId, r.startId);
                    } else {
                        ((RelationshipVisitor)invocation.getArguments()[1]).visit(r.relId, r.type, r.startId, r.neighborId);
                    }
                    return true;
                }
            });
        }
        Mockito.when((Object)state.addedRelationships(nodeId, (int[])this.relTypes.read(), (Direction)this.expandDirection.read())).thenReturn((Object)PrimitiveLongCollections.iterator((long[])new long[]{1337L, 1338L}));
    }

    private void givenStoredRels(StoreReadLayer store, final ExpandTestUtils.Row ... rows) {
        Mockito.when((Object)store.expand((Cursor)Mockito.any(Cursor.class), (NeoRegister.Node.In)Mockito.any(NeoRegister.Node.In.class), (Register.Object.In)Mockito.any(Register.Object.In.class), (Register.Object.In)Mockito.any(Register.Object.In.class), (NeoRegister.Relationship.Out)Mockito.any(NeoRegister.Relationship.Out.class), (NeoRegister.RelType.Out)Mockito.any(NeoRegister.RelType.Out.class), (Register.Object.Out)Mockito.any(Register.Object.Out.class), (NeoRegister.Node.Out)Mockito.any(NeoRegister.Node.Out.class), (NeoRegister.Node.Out)Mockito.any(NeoRegister.Node.Out.class))).thenAnswer((Answer)new Answer<Cursor>(){

            public Cursor answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                final Cursor input = (Cursor)args[0];
                final NeoRegister.Relationship.Out relId = (NeoRegister.Relationship.Out)args[4];
                final NeoRegister.RelType.Out relType = (NeoRegister.RelType.Out)args[5];
                final Register.Object.Out direction = (Register.Object.Out)args[6];
                final NeoRegister.Node.Out startNodeId = (NeoRegister.Node.Out)args[7];
                final NeoRegister.Node.Out neighborNodeId = (NeoRegister.Node.Out)args[8];
                return new Cursor(){
                    private Iterator<ExpandTestUtils.Row> rowIter = Iterators.empty();

                    public boolean next() {
                        if (this.rowIter.hasNext()) {
                            ExpandTestUtils.Row next = this.rowIter.next();
                            relId.write(next.relId);
                            relType.write(next.type);
                            direction.write((Object)next.direction);
                            startNodeId.write(next.startId);
                            neighborNodeId.write(next.neighborId);
                            return true;
                        }
                        if (input.next()) {
                            this.rowIter = Arrays.asList(rows).iterator();
                            return this.next();
                        }
                        return false;
                    }

                    public void reset() {
                        this.rowIter = Iterators.empty();
                    }

                    public void close() {
                    }
                };
            }
        });
    }
}

