/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.util.PrimitiveIteratorMatchers;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;
import org.neo4j.test.RandomizedTestRule;
import org.neo4j.test.RepeatRule;

public class TxStateTest {
    public final RandomizedTestRule random = new RandomizedTestRule();
    private TransactionState state;
    private final Set<Long> emptySet = Collections.emptySet();

    @Rule
    public final TestRule repeatWithDifferentRandomization() {
        return RuleChain.outerRule((TestRule)new RepeatRule()).around((TestRule)this.random);
    }

    @Test
    public void shouldGetAddedLabels() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        Set addedLabels = this.state.nodeStateLabelDiffSets(1L).getAdded();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{1, 2}), (Object)addedLabels);
    }

    @Test
    public void shouldGetRemovedLabels() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        Set removedLabels = this.state.nodeStateLabelDiffSets(1L).getRemoved();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{1, 2}), (Object)removedLabels);
    }

    @Test
    public void removeAddedLabelShouldRemoveFromAdded() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        this.state.nodeDoRemoveLabel(1, 1L);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getAdded());
    }

    @Test
    public void addRemovedLabelShouldRemoveFromRemoved() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        this.state.nodeDoAddLabel(1, 1L);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getRemoved());
    }

    @Test
    public void shouldMapFromRemovedLabelToNodes() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(2, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(3, 1L);
        this.state.nodeDoRemoveLabel(2, 2L);
        Set nodes = this.state.nodesWithLabelChanged(2).getRemoved();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{0L, 2L}), (Object)IteratorUtil.asSet((Iterable)nodes));
    }

    @Test
    public void shouldAddAndGetByLabel() throws Exception {
        int labelId = 2;
        int labelId2 = 5;
        int propertyKey = 3;
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        this.state.indexRuleDoAdd(rule);
        this.state.indexRuleDoAdd(new IndexDescriptor(labelId2, propertyKey));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule}), (Object)this.state.indexDiffSetsByLabel(labelId).getAdded());
    }

    @Test
    public void shouldAddAndGetByRuleId() throws Exception {
        int labelId = 2;
        int propertyKey = 3;
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        this.state.indexRuleDoAdd(rule);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule}), (Object)this.state.indexChanges().getAdded());
    }

    @Test
    public void shouldIncludeAddedNodesWithCorrectProperty() throws Exception {
        long nodeId = 1337L;
        int propertyKey = 2;
        String propValue = "hello";
        this.state.nodeDoReplaceProperty(nodeId, Property.noNodeProperty((long)nodeId, (int)propertyKey), Property.stringProperty((int)propertyKey, (String)propValue));
        ReadableDiffSets diff = this.state.nodesWithChangedProperty(propertyKey, (Object)propValue);
        Assert.assertThat((Object)diff.getAdded(), (Matcher)IsEqual.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId})));
        Assert.assertThat((Object)diff.getRemoved(), (Matcher)IsEqual.equalTo(this.emptySet));
    }

    @Test
    public void shouldExcludeNodesWithCorrectPropertyRemoved() throws Exception {
        long nodeId = 1337L;
        int propertyKey = 2;
        String propValue = "hello";
        this.state.nodeDoRemoveProperty(nodeId, Property.stringProperty((int)propertyKey, (String)propValue));
        ReadableDiffSets diff = this.state.nodesWithChangedProperty(propertyKey, (Object)propValue);
        Assert.assertThat((Object)diff.getAdded(), (Matcher)IsEqual.equalTo(this.emptySet));
        Assert.assertThat((Object)diff.getRemoved(), (Matcher)IsEqual.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId})));
    }

    @Test
    public void shouldListNodeAsDeletedIfItIsDeleted() throws Exception {
        long nodeId = 1337L;
        this.state.nodeDoDelete(nodeId);
        Assert.assertThat((Object)IteratorUtil.asSet((Iterable)this.state.addedAndRemovedNodes().getRemoved()), (Matcher)IsEqual.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId})));
    }

    @Test
    public void shouldAddUniquenessConstraint() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint, 7L);
        ReadableDiffSets diff = this.state.constraintsChangesForLabel(1);
        Assert.assertEquals(Collections.singleton(constraint), (Object)diff.getAdded());
        Assert.assertTrue((boolean)diff.getRemoved().isEmpty());
    }

    @Test
    public void addingUniquenessConstraintShouldBeIdempotent() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint1, 7L);
        UniquenessConstraint constraint2 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint2, 19L);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
    }

    @Test
    public void shouldDifferentiateBetweenUniquenessConstraintsForDifferentLabels() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint1, 7L);
        UniquenessConstraint constraint2 = new UniquenessConstraint(2, 17);
        this.state.constraintDoAdd(constraint2, 19L);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForLabel(2).getAdded());
    }

    @Test
    public void shouldListRelationshipsAsCreatedIfCreated() throws Exception {
        long relId = 10L;
        this.state.relationshipDoCreate(relId, 0, 1L, 2L);
        Assert.assertTrue((boolean)this.state.hasChanges());
        Assert.assertTrue((boolean)this.state.relationshipIsAddedInThisTx(relId));
    }

    @Test
    public void shouldAugmentWithAddedRelationships() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relId = 10L;
        this.state.relationshipDoCreate(relId, relType, (long)startNode, (long)endNode);
        long otherRel = relId + 1L;
        Assert.assertTrue((boolean)this.state.hasChanges());
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.OUTGOING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.INCOMING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(relId, otherRel));
        Assert.assertThat((Object)this.state.addedRelationships((long)endNode, new int[]{relType}, Direction.BOTH), PrimitiveIteratorMatchers.containsLongs(relId));
        Assert.assertThat((Object)this.state.addedRelationships((long)endNode, new int[]{relType + 1}, Direction.BOTH), PrimitiveIteratorMatchers.containsLongs(new long[0]));
    }

    @Test
    public void addedAndThenRemovedRelShouldNotShowUp() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relId = 10L;
        this.state.relationshipDoCreate(relId, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relId, relType, (long)startNode, (long)endNode);
        long otherRel = relId + 1L;
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.OUTGOING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)startNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.INCOMING, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
        Assert.assertThat((Object)this.state.augmentRelationships((long)endNode, Direction.BOTH, PrimitiveLongCollections.iterator((long[])new long[]{otherRel})), PrimitiveIteratorMatchers.containsLongs(otherRel));
    }

    @Test
    public void shouldGiveCorrectDegreeWhenAddingAndRemovingRelationships() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        this.state.relationshipDoCreate(10L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(11L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(12L, relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(13L, relType + 1, (long)endNode, (long)startNode);
        this.state.relationshipDoDelete(1337L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(1338L, relType + 1, (long)startNode, (long)startNode);
        Assert.assertEquals((long)12L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH));
        Assert.assertEquals((long)10L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.INCOMING));
        Assert.assertEquals((long)11L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH, relType));
    }

    @Test
    public void shouldGiveCorrectRelationshipTypesForNode() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relA = 10L;
        long relB = 11L;
        long relC = 12L;
        this.state.relationshipDoCreate(relA, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relB, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relC, relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relB, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relC, relType + 1, (long)startNode, (long)endNode);
        Assert.assertThat((Object)IteratorUtil.asList((PrimitiveIntIterator)this.state.nodeRelationshipTypes((long)startNode)), (Matcher)IsEqual.equalTo(Arrays.asList(relType)));
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedNode() throws Exception {
        this.state.nodeDoCreate(0L);
        this.state.nodeDoDelete(0L);
        this.state.nodeDoCreate(1L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedNode(long id) {
                Assert.assertEquals((String)"Should not create any other node than 1", (long)1L, (long)id);
            }

            public void visitDeletedNode(long id) {
                Assert.fail((String)"Should not delete any node");
            }
        });
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedRelationship() throws Exception {
        this.state.relationshipDoCreate(0L, 0, 1L, 2L);
        this.state.relationshipDoDelete(0L, 0, 1L, 2L);
        this.state.relationshipDoCreate(1L, 0, 2L, 3L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                Assert.assertEquals((String)"Should not create any other relationship than 1", (long)1L, (long)id);
            }

            public void visitDeletedRelationship(long id) {
                Assert.fail((String)"Should not delete any relationship");
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeDeletedNodes() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeCreatedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedRelationshipsBeforeDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoDelete((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitEarly();
            }

            public void visitDeletedRelationship(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitDeletedNodesAfterDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitDeletedRelationship(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Before
    public void before() throws Exception {
        this.state = new TxState();
    }

    abstract class VisitationOrder
    extends TxStateVisitor.Adapter {
        private final Set<String> visitMethods = new HashSet<String>();
        private boolean late;

        VisitationOrder(int size) {
            for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
                if (!method.getName().startsWith("visit")) continue;
                this.visitMethods.add(method.getName());
            }
            Assert.assertEquals((String)"should implement exactly two visit*(...) methods", (long)2L, (long)this.visitMethods.size());
            do {
                if (TxStateTest.this.random.nextBoolean()) {
                    this.createEarlyState();
                    continue;
                }
                this.createLateState();
            } while (size-- > 0);
        }

        abstract void createEarlyState();

        abstract void createLateState();

        final void visitEarly() {
            if (this.late) {
                String early = "the early visit*-method";
                String late = "the late visit*-method";
                for (StackTraceElement trace : Thread.currentThread().getStackTrace()) {
                    if (!this.visitMethods.contains(trace.getMethodName())) continue;
                    early = trace.getMethodName();
                    for (String method : this.visitMethods) {
                        if (method.equals(early)) continue;
                        late = method;
                    }
                    break;
                }
                Assert.fail((String)(early + "(...) should not be invoked after " + late + "(...)"));
            }
        }

        final void visitLate() {
            this.late = true;
        }
    }
}

