/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;

public class SchemaCacheTest {
    final SchemaRule hans = this.newIndexRule(1L, 0, 5);
    final SchemaRule witch = this.newIndexRule(2L, 3, 6);
    final SchemaRule gretel = this.newIndexRule(3L, 0, 7);

    @Test
    public void should_construct_schema_cache() {
        List<SchemaRule> rules = Arrays.asList(this.hans, this.witch, this.gretel);
        SchemaCache cache = new SchemaCache(rules);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)IteratorUtil.asSet((Iterable)cache.schemaRulesForLabel(0)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new SchemaRule[]{this.witch}), (Object)IteratorUtil.asSet((Iterable)cache.schemaRulesForLabel(3)));
        Assert.assertEquals((Object)IteratorUtil.asSet(rules), (Object)IteratorUtil.asSet((Iterable)cache.schemaRules()));
    }

    @Test
    public void should_add_schema_rules_to_a_label() {
        List<Object> rules = Arrays.asList(new Object[0]);
        SchemaCache cache = new SchemaCache(rules);
        cache.addSchemaRule(this.hans);
        cache.addSchemaRule(this.gretel);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)IteratorUtil.asSet((Iterable)cache.schemaRulesForLabel(0)));
    }

    @Test
    public void should_to_retrieve_all_schema_rules() {
        List<Object> rules = Arrays.asList(new Object[0]);
        SchemaCache cache = new SchemaCache(rules);
        cache.addSchemaRule(this.hans);
        cache.addSchemaRule(this.gretel);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)IteratorUtil.asSet((Iterable)cache.schemaRules()));
    }

    @Test
    public void should_list_constraints() {
        List<Object> rules = Arrays.asList(new Object[0]);
        SchemaCache cache = new SchemaCache(rules);
        cache.addSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        cache.addSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)1L, (int)3, (int)4, (long)133L));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(1, 2), new UniquenessConstraint(3, 4)}), (Object)IteratorUtil.asSet((Iterator)cache.constraints()));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(1, 2)}), (Object)IteratorUtil.asSet((Iterator)cache.constraintsForLabel(1)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(1, 2)}), (Object)IteratorUtil.asSet((Iterator)cache.constraintsForLabelAndProperty(1, 2)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Object[0]), (Object)IteratorUtil.asSet((Iterator)cache.constraintsForLabelAndProperty(1, 3)));
    }

    @Test
    public void should_remove_constraints() {
        List<Object> rules = Arrays.asList(new Object[0]);
        SchemaCache cache = new SchemaCache(rules);
        cache.addSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        cache.addSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)1L, (int)3, (int)4, (long)133L));
        cache.removeSchemaRule(0L);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new UniquenessConstraint[]{new UniquenessConstraint(3, 4)}), (Object)IteratorUtil.asSet((Iterator)cache.constraints()));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Object[0]), (Object)IteratorUtil.asSet((Iterator)cache.constraintsForLabel(1)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Object[0]), (Object)IteratorUtil.asSet((Iterator)cache.constraintsForLabelAndProperty(1, 2)));
    }

    @Test
    public void adding_constraints_should_be_idempotent() throws Exception {
        List<Object> rules = Arrays.asList(new Object[0]);
        SchemaCache cache = new SchemaCache(rules);
        cache.addSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        cache.addSchemaRule((SchemaRule)UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)133L));
        Assert.assertEquals(Arrays.asList(new UniquenessConstraint(1, 2)), (Object)IteratorUtil.asList((Iterator)cache.constraints()));
    }

    @Test
    public void shouldResolveIndexId() throws Exception {
        List<Object> rules = Arrays.asList(new Object[0]);
        SchemaCache cache = new SchemaCache(rules);
        cache.addSchemaRule((SchemaRule)this.newIndexRule(1L, 1, 2));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(2L, 1, 3));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(3L, 2, 2));
        long indexId = cache.indexId(new IndexDescriptor(1, 3));
        Assert.assertThat((Object)indexId, (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldResolveIndexDescriptor() throws Exception {
        List<Object> rules = Arrays.asList(new Object[0]);
        SchemaCache cache = new SchemaCache(rules);
        cache.addSchemaRule((SchemaRule)this.newIndexRule(1L, 1, 2));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(2L, 1, 3));
        cache.addSchemaRule((SchemaRule)this.newIndexRule(3L, 2, 2));
        IndexDescriptor descriptor = cache.indexDescriptor(1, 3);
        Assert.assertEquals((long)1L, (long)descriptor.getLabelId());
        Assert.assertEquals((long)3L, (long)descriptor.getPropertyKeyId());
    }

    @Test
    public void shouldReturnNullWhenNoIndexExists() {
        SchemaCache schemaCache = new SchemaCache(Iterables.empty());
        IndexDescriptor indexDescriptor = schemaCache.indexDescriptor(1, 1);
        Assert.assertNull((Object)indexDescriptor);
    }

    private IndexRule newIndexRule(long id, int label, int propertyKey) {
        return IndexRule.indexRule((long)id, (int)label, (int)propertyKey, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
    }
}

