/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.StoreExpandCursor;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.kernel.impl.util.register.NeoRegisters;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class StoreExpandCursorTest {
    @Test
    public void shouldDelegateToGetRelsAndRelVisitor() throws Exception {
        PrimitiveLongIterator rels = PrimitiveLongCollections.iterator((long[])new long[]{1L});
        CacheLayer cache = (CacheLayer)Mockito.mock(CacheLayer.class);
        Mockito.when((Object)cache.nodeListRelationships(Mockito.anyLong(), (Direction)Mockito.any(Direction.class), (int[])Mockito.any(int[].class))).thenReturn((Object)rels);
        ((CacheLayer)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RelationshipVisitor visitor = (RelationshipVisitor)invocation.getArguments()[1];
                visitor.visit(((Long)invocation.getArguments()[0]).longValue(), 0, 1337L, 2L);
                return null;
            }
        }).when((Object)cache)).relationshipVisit(Mockito.anyLong(), (RelationshipVisitor)Mockito.any(RelationshipVisitor.class));
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startNodeId = NeoRegisters.newNodeRegister();
        NeoRegister.NodeRegister neighborNodeId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        StoreExpandCursor cursor = new StoreExpandCursor(cache, Cursors.countDownCursor((int)1), (NeoRegister.Node.In)NeoRegisters.newNodeRegister((long)1337L), (Register.Object.In)Registers.newObjectRegister((Object)new int[]{1, 2, 3}), (Register.Object.In)Registers.newObjectRegister((Object)Direction.BOTH), (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startNodeId, (NeoRegister.Node.Out)neighborNodeId);
        cursor.next();
        ((CacheLayer)Mockito.verify((Object)cache)).nodeListRelationships(1337L, Direction.BOTH, new int[]{1, 2, 3});
        MatcherAssert.assertThat((Object)relId.read(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)startNodeId.read(), (Matcher)CoreMatchers.equalTo((Object)1337L));
        MatcherAssert.assertThat((Object)neighborNodeId.read(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)relType.read(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)direction.read(), (Matcher)CoreMatchers.equalTo((Object)Direction.OUTGOING));
        Assert.assertFalse((boolean)cursor.next());
    }
}

