/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class NodeProxyTest {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();
    private final String PROPERTY_KEY = "PROPERTY_KEY";
    private GraphDatabaseService db;

    @Before
    public void init() {
        this.db = this.dbRule.getGraphDatabaseService();
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExistOnNode() throws Exception {
        this.createNodeWith("PROPERTY_KEY");
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
            Assert.fail((String)"Expected exception to have been thrown");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExist() throws Exception {
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test(expected=NotFoundException.class)
    public void deletionOfSameNodeTwiceInOneTransactionShouldNotRollbackIt() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        Exception exceptionThrownBySecondDelete = null;
        try (Transaction tx = this.db.beginTx();){
            node.delete();
            try {
                node.delete();
            }
            catch (Exception e) {
                exceptionThrownBySecondDelete = e;
            }
            tx.success();
        }
        Assert.assertThat((Object)exceptionThrownBySecondDelete, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        tx = this.db.beginTx();
        var4_6 = null;
        try {
            this.db.getNodeById(node.getId());
            tx.success();
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_6.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void deletionOfAlreadyDeletedNodeShouldThrow() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable x2) {
            var3_2 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void createNodeWith(String key) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty(key, (Object)1);
            tx.success();
        }
    }
}

