/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestIdReuse {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void makeSureIdsGetsReusedForPropertyStore() throws Exception {
        this.makeSureIdsGetsReused("neostore.propertystore.db", 10, 200);
    }

    @Test
    public void makeSureIdsGetsReusedForArrayStore() throws Exception {
        long[] array = new long[500];
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0xFFFFFFFFFFFFL + (long)i;
        }
        this.makeSureIdsGetsReused("neostore.propertystore.db.arrays", array, 20);
    }

    @Test
    public void makeSureIdsGetsReusedForStringStore() throws Exception {
        String string = "something";
        for (int i = 0; i < 100; ++i) {
            string = string + "something else " + i;
        }
        this.makeSureIdsGetsReused("neostore.propertystore.db.strings", string, 20);
    }

    private void makeSureIdsGetsReused(String fileName, Object value, int iterations) throws Exception {
        File storeDir = new File("target/var/idreuse");
        File file = new File(storeDir, fileName);
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabaseBuilder(storeDir.getPath()).newGraphDatabase();
        for (int i = 0; i < 5; ++i) {
            this.setAndRemoveSomeProperties(db, value);
        }
        db.shutdown();
        long sizeBefore = file.length();
        db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabase(storeDir.getPath());
        for (int i = 0; i < iterations; ++i) {
            this.setAndRemoveSomeProperties(db, value);
        }
        db.shutdown();
        Assert.assertEquals((long)sizeBefore, (long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAndRemoveSomeProperties(GraphDatabaseService graphDatabaseService, Object value) {
        int i;
        Transaction tx = graphDatabaseService.beginTx();
        Node commonNode = graphDatabaseService.createNode();
        try {
            for (i = 0; i < 10; ++i) {
                commonNode.setProperty("key" + i, value);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = graphDatabaseService.beginTx();
        try {
            for (i = 0; i < 10; ++i) {
                commonNode.removeProperty("key" + i);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }
}

