/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.SingleChainPosition;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.util.RelIdArray;

public class TestOperationsOnDeletedRelationships {
    @Test
    public void shouldThrowNotFoundOnGetAllRelationshipsWhenRelationshipConcurrentlyDeleted() throws Exception {
        NodeImpl nodeImpl = new NodeImpl(1337L);
        RelationshipLoader loader = (RelationshipLoader)Mockito.mock(RelationshipLoader.class);
        CacheUpdateListener cacheUpdateListener = (CacheUpdateListener)Mockito.mock(CacheUpdateListener.class);
        Mockito.when((Object)loader.getRelationshipChainPosition(Matchers.anyLong())).thenReturn((Object)new SingleChainPosition(1L));
        Mockito.when((Object)loader.getMoreRelationships((NodeImpl)Matchers.any(NodeImpl.class), (RelIdArray.DirectionWrapper)Matchers.any(RelIdArray.DirectionWrapper.class), (int[])Matchers.any(int[].class))).thenThrow(new Throwable[]{new InvalidRecordException("LURING!")});
        try {
            nodeImpl.getAllRelationships(loader, RelIdArray.DirectionWrapper.BOTH, cacheUpdateListener);
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNotFoundWhenIteratingOverDeletedRelationship() throws Exception {
        NodeImpl fromNode = new NodeImpl(1337L);
        RelationshipLoader loader = (RelationshipLoader)Mockito.mock(RelationshipLoader.class);
        CacheUpdateListener cacheUpdateListener = (CacheUpdateListener)Mockito.mock(CacheUpdateListener.class);
        Mockito.when((Object)loader.getMoreRelationships((NodeImpl)Matchers.any(NodeImpl.class), (RelIdArray.DirectionWrapper)Matchers.any(RelIdArray.DirectionWrapper.class), (int[])Matchers.any(int[].class))).thenThrow(new Throwable[]{new InvalidRecordException("LURING!")});
        fromNode.setRelChainPosition((RelationshipLoadingPosition)new SingleChainPosition(1L));
        try {
            fromNode.getMoreRelationships(loader, RelIdArray.DirectionWrapper.BOTH, new int[0], cacheUpdateListener);
            Assert.fail((String)"Should throw exception");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
    }
}

