/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="Jake: This assumes completely fair locking, which is not guaranteed, discuss what to do here before merging.")
public class TestRaceOnMultipleNodeImpl {
    private GraphDatabaseAPI graphdb;

    @Test
    public void concurrentRemoveProperty() throws Exception {
        final Node root = this.tx(new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                return TestRaceOnMultipleNodeImpl.this.graphdb.createNode();
            }
        });
        final Node original = this.tx(new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                Node node = TestRaceOnMultipleNodeImpl.this.graphdb.createNode();
                node.setProperty("key", (Object)"original");
                return node;
            }
        });
        final CountDownLatch removerSetUp = this.latch();
        final CountDownLatch waitChainSetUp = this.latch();
        this.txThread("remover", new Runnable(){

            @Override
            public void run() {
                original.removeProperty("key");
                removerSetUp.countDown();
                TestRaceOnMultipleNodeImpl.await(waitChainSetUp);
            }
        });
        TestRaceOnMultipleNodeImpl.await(removerSetUp);
        this.clearCaches();
        TestRaceOnMultipleNodeImpl.awaitWaitingState(this.txThread("blocker", new Runnable(){

            @Override
            public void run() {
                original.removeProperty("not existing");
                root.setProperty("key", (Object)"root");
            }
        }));
        this.clearCaches();
        final AtomicBoolean precondition = new AtomicBoolean(false);
        final CountDownLatch readyToBlockOnLock = this.latch();
        final CountDownLatch done = this.latch();
        Thread offender = TestRaceOnMultipleNodeImpl.thread("offender", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TestRaceOnMultipleNodeImpl.this.tx(new Runnable(){

                        @Override
                        public void run() {
                            precondition.set("original".equals(original.getProperty("key")));
                            readyToBlockOnLock.countDown();
                            original.removeProperty("key");
                        }
                    });
                }
                finally {
                    done.countDown();
                }
            }
        });
        TestRaceOnMultipleNodeImpl.await(readyToBlockOnLock);
        TestRaceOnMultipleNodeImpl.awaitWaitingState(offender);
        this.clearCaches();
        waitChainSetUp.countDown();
        TestRaceOnMultipleNodeImpl.await(done);
        this.clearCaches();
        Assert.assertThat((Object)root, Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb, Neo4jMatchers.hasProperty("key")));
        Assert.assertTrue((String)"invalid precondition", (boolean)precondition.get());
    }

    @Test
    public void concurrentSetProperty() throws Exception {
        final Node root = this.tx(new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                return TestRaceOnMultipleNodeImpl.this.graphdb.createNode();
            }
        });
        this.tx(new Runnable(){

            @Override
            public void run() {
                root.setProperty("tx", (Object)"main");
                root.setProperty("a", (Object)1);
                root.setProperty("b", (Object)2);
                root.setProperty("c", (Object)3);
                root.setProperty("d", (Object)4);
            }
        });
        final CountDownLatch writerSetUp = this.latch();
        final CountDownLatch waitChainSetUp = this.latch();
        this.txThread("writer", new Runnable(){

            @Override
            public void run() {
                root.setProperty("e", (Object)5);
                writerSetUp.countDown();
                TestRaceOnMultipleNodeImpl.await(waitChainSetUp);
                root.setProperty("tx", (Object)"writer");
            }
        });
        TestRaceOnMultipleNodeImpl.await(writerSetUp);
        TestRaceOnMultipleNodeImpl.awaitWaitingState(this.txThread("remover", new Runnable(){

            @Override
            public void run() {
                root.removeProperty("tx");
            }
        }));
        this.clearCaches();
        final AtomicBoolean precondition = new AtomicBoolean(false);
        final CountDownLatch offenderSetUp = this.latch();
        final CountDownLatch done = this.latch();
        Thread offender = TestRaceOnMultipleNodeImpl.thread("offender", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TestRaceOnMultipleNodeImpl.this.tx(new Runnable(){

                        @Override
                        public void run() {
                            for (String key : root.getPropertyKeys()) {
                                precondition.set(true);
                            }
                            offenderSetUp.countDown();
                            root.setProperty("tx", (Object)"offender");
                        }
                    });
                }
                finally {
                    done.countDown();
                }
            }
        });
        TestRaceOnMultipleNodeImpl.await(offenderSetUp);
        TestRaceOnMultipleNodeImpl.awaitWaitingState(offender);
        this.clearCaches();
        waitChainSetUp.countDown();
        TestRaceOnMultipleNodeImpl.await(done);
        this.clearCaches();
        Assert.assertThat((Object)root, Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb, Neo4jMatchers.hasProperty("tx").withValue("offender")));
        Assert.assertTrue((String)"node should not have any properties when entering second tx", (boolean)precondition.get());
    }

    private CountDownLatch latch() {
        return new CountDownLatch(1);
    }

    private static void await(CountDownLatch latch) {
        while (true) {
            try {
                latch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void clearCaches() {
        ((Caches)this.graphdb.getDependencyResolver().resolveDependency(Caches.class)).clear();
    }

    private static Thread thread(String name, Runnable task) {
        Thread thread = new Thread(task, name);
        thread.start();
        return thread;
    }

    private static void awaitWaitingState(Thread thread) {
        while (true) {
            switch (thread.getState()) {
                case WAITING: 
                case TIMED_WAITING: {
                    return;
                }
                case TERMINATED: {
                    throw new IllegalStateException("thread terminated");
                }
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    private Thread txThread(String name, final Runnable task) {
        return TestRaceOnMultipleNodeImpl.thread(name, new Runnable(){

            @Override
            public void run() {
                TestRaceOnMultipleNodeImpl.this.tx(task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tx(Runnable task) {
        Transaction tx = this.graphdb.beginTx();
        try {
            task.run();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R tx(Callable<R> task) throws Exception {
        Transaction tx = this.graphdb.beginTx();
        try {
            R result = task.call();
            tx.success();
            R r = result;
            return r;
        }
        finally {
            tx.finish();
        }
    }

    @Before
    public void startDb() {
        this.graphdb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void shutdownDb() {
        try {
            if (this.graphdb != null) {
                this.graphdb.shutdown();
            }
        }
        finally {
            this.graphdb = null;
        }
    }
}

