/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.index.IndexProviderStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;

public class TestIndexProviderStore {
    private File file;
    private FileSystemAbstraction fileSystem;

    @Before
    public void createStore() {
        this.file = new File("target/test-data/index-provider-store");
        this.fileSystem = new DefaultFileSystemAbstraction();
        this.file.mkdirs();
        this.fileSystem.deleteFile(this.file);
    }

    @Test
    public void lastCommitedTxGetsStoredBetweenSessions() throws Exception {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        store.setVersion(5L);
        store.setLastCommittedTx(12L);
        store.close();
        store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        Assert.assertEquals((long)5L, (long)store.getVersion());
        Assert.assertEquals((long)12L, (long)store.getLastCommittedTx());
        store.close();
    }

    @Test
    public void shouldFailUpgradeIfNotAllowed() {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.1"), true);
        store.close();
        store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.1"), false);
        store.close();
        try {
            new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.5"), false);
            Assert.fail((String)"Shouldn't be able to upgrade there");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
        store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.5"), true);
        Assert.assertEquals((Object)"3.5", (Object)NeoStore.versionLongToString((long)store.getIndexVersion()));
        store.close();
    }

    @Test(expected=NotCurrentStoreVersionException.class)
    public void shouldFailToGoBackToOlderVersion() throws Exception {
        String newerVersion = "3.5";
        String olderVersion = "3.1";
        try {
            IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)newerVersion), true);
            store.close();
            store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)olderVersion), false);
        }
        catch (NotCurrentStoreVersionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(newerVersion));
            Assert.assertTrue((boolean)e.getMessage().contains(olderVersion));
            throw e;
        }
    }

    @Test(expected=NotCurrentStoreVersionException.class)
    public void shouldFailToGoBackToOlderVersionEvenIfAllowUpgrade() throws Exception {
        String newerVersion = "3.5";
        String olderVersion = "3.1";
        try {
            IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)newerVersion), true);
            store.close();
            store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)olderVersion), true);
        }
        catch (NotCurrentStoreVersionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(newerVersion));
            Assert.assertTrue((boolean)e.getMessage().contains(olderVersion));
            throw e;
        }
    }

    @Test
    public void upgradeForMissingVersionRecord() throws Exception {
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
        store.close();
        FileUtils.truncateFile((File)this.file, (long)32L);
        try {
            store = new IndexProviderStore(this.file, this.fileSystem, 0L, false);
            Assert.fail((String)"Should have thrown upgrade exception");
        }
        catch (UpgradeNotAllowedByConfigurationException upgradeNotAllowedByConfigurationException) {
            // empty catch block
        }
        store = new IndexProviderStore(this.file, this.fileSystem, 0L, true);
        store.close();
    }

    @Test
    public void shouldForceChannelAfterWritingMetadata() throws IOException {
        final StoreChannel[] channelUsedToCreateFile = new StoreChannel[]{null};
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.spy((Object)this.fileSystem);
        StoreChannel tempChannel = fs.open(this.file, "rw");
        Mockito.when((Object)tempChannel).then((Answer)new Answer<StoreChannel>(){

            public StoreChannel answer(InvocationOnMock _) throws Throwable {
                StoreChannel channel = TestIndexProviderStore.this.fileSystem.open(TestIndexProviderStore.this.file, "rw");
                if (channelUsedToCreateFile[0] == null) {
                    StoreChannel channelSpy;
                    channelUsedToCreateFile[0] = channelSpy = (StoreChannel)Mockito.spy((Object)channel);
                    channel = channelSpy;
                }
                return channel;
            }
        });
        tempChannel.close();
        fs.deleteFile(this.file);
        IndexProviderStore store = new IndexProviderStore(this.file, fs, NeoStore.versionStringToLong((String)"3.5"), false);
        StoreChannel channel = channelUsedToCreateFile[0];
        ((StoreChannel)Mockito.verify((Object)channel)).write((ByteBuffer)Matchers.any(ByteBuffer.class), Matchers.eq((long)0L));
        ((StoreChannel)Mockito.verify((Object)channel)).force(true);
        ((StoreChannel)Mockito.verify((Object)channel)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
        store.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenTryingToCreateFileThatAlreadyExists() {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(this.file)).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)fs.getFileSize(this.file)).thenReturn((Object)42L);
        new IndexProviderStore(this.file, fs, NeoStore.versionStringToLong((String)"3.5"), false);
    }

    @Test
    public void shouldWriteNewFileWhenExistingFileHasZeroLength() throws IOException {
        this.file.createNewFile();
        IndexProviderStore store = new IndexProviderStore(this.file, this.fileSystem, NeoStore.versionStringToLong((String)"3.5"), false);
        Assert.assertTrue((this.fileSystem.getFileSize(this.file) > 0L ? 1 : 0) != 0);
        store.close();
    }
}

