/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class LockReentrancyCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public LockReentrancyCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Test
    public void shouldAcquireExclusiveIfClientIsOnlyOneHoldingShared() throws Exception {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void shouldRetainExclusiveLockAfterReleasingSharedLock() throws Exception {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void shouldRetainSharedLockWhenAcquiredAfterExclusiveLock() throws Exception {
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void sharedLocksShouldStack() throws Exception {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void exclusiveLocksShouldBeReentrantAndBlockOtherExclusiveLocks() throws Exception {
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void exclusiveLocksShouldBeReentrantAndBlockOtherSharedLocks() throws Exception {
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.tryExclusiveLock((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void sharedLocksShouldNotReplaceExclusiveLocks() throws Exception {
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void releaseAllSharedLeavesExclusiveLocksInPlace() throws Exception {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Object> clientBLock = this.acquireShared(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseAllShared();
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }

    @Test
    public void releaseAllExclusiveLeavesSharedLocksInPlace() throws Exception {
        this.clientA.acquireShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientA.acquireExclusive((Locks.ResourceType)ResourceTypes.NODE, new long[]{2L});
        Future<Object> clientBLock = this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientA.releaseAllExclusive();
        this.assertWaiting(this.clientB, clientBLock);
        this.clientA.releaseShared((Locks.ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.assertNotWaiting(this.clientB, clientBLock);
    }
}

