/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class StoreHighIdInflationTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final String storeDir = new File("dir").getAbsolutePath();

    @Test
    public void shouldFindActualHighIdWhenStartingOnInflatedStore() throws Exception {
        EphemeralFileSystemAbstraction fs = this.fsr.get();
        fs.mkdirs(new File(this.storeDir));
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.newImpermanentDb();
        long highestCreatedNodeId = this.createACoupleOfNodes((GraphDatabaseService)db, 3);
        long highestPropertyStringRecord = this.getHighestDynamicStringPropertyId(db);
        db.shutdown();
        this.inflateStore("NodeStore", ".nodestore.db", this.megabyteWorthOfZeros());
        this.inflateStore("StringPropertyStore", ".propertystore.db.strings", this.megabyteWorthOfZeros());
        db = (GraphDatabaseAPI)this.newImpermanentDb();
        long nodeIdAfterInflation = this.createACoupleOfNodes((GraphDatabaseService)db, 1);
        long stringPropertyIdAfterInflation = this.getHighestDynamicStringPropertyId(db);
        db.shutdown();
        Assert.assertEquals((long)(highestCreatedNodeId + 1L), (long)nodeIdAfterInflation);
        Assert.assertEquals((long)(highestPropertyStringRecord + 1L), (long)stringPropertyIdAfterInflation);
    }

    @Test
    public void shouldTrimInflatedTokenStoreDuringRecovery() throws IOException {
        int nodesWithUniqueLabels = 10;
        int relsWithUniqueTypes = 5;
        EphemeralFileSystemAbstraction fs = this.fsr.get();
        fs.mkdirs(new File(this.storeDir));
        GraphDatabaseService db = this.newImpermanentDb();
        StoreHighIdInflationTest.createLabeledNodesAndRels(nodesWithUniqueLabels, relsWithUniqueTypes, db);
        int labelTokenRecordSize = StoreHighIdInflationTest.neoStoreOf(db).getLabelTokenStore().getRecordSize();
        db.shutdown();
        this.inflateStore("LabelTokenStore", ".labeltokenstore.db", this.megabyteWorthOfZeros());
        this.newImpermanentDb().shutdown();
        long fileSize = fs.getFileSize(new File(this.storeDir, "neostore.labeltokenstore.db"));
        int trailerLength = StoreHighIdInflationTest.trailerLength("LabelTokenStore");
        Assert.assertEquals((String)("Unexpected file size; trailerLength=" + trailerLength), (long)(nodesWithUniqueLabels * labelTokenRecordSize), (long)(fileSize - (long)trailerLength));
    }

    private static NeoStore neoStoreOf(GraphDatabaseService db) {
        return (NeoStore)((NeoStoreProvider)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(NeoStoreProvider.class)).evaluate();
    }

    @Test
    public void shouldMarkReservedRelationshipTypesAsNotInUse() throws IOException {
        int nodesWithUniqueLabels = 5;
        int relsWithUniqueTypes = 10;
        int reservedRelTypeRecordsCount = 100;
        String relTypeStoreFileName = "neostore.relationshiptypestore.db";
        EphemeralFileSystemAbstraction fs = this.fsr.get();
        fs.mkdirs(new File(this.storeDir));
        GraphDatabaseService db = this.newImpermanentDb();
        StoreHighIdInflationTest.createLabeledNodesAndRels(nodesWithUniqueLabels, relsWithUniqueTypes, db);
        int relTypeTokenRecordSize = StoreHighIdInflationTest.relTypeTokenStore(db).getRecordSize();
        Assert.assertEquals((String)"Unexpected highest inUse id", (long)(relsWithUniqueTypes - 1), (long)StoreHighIdInflationTest.relTypeTokenStore(db).getHighestPossibleIdInUse());
        db.shutdown();
        this.inflateStore("RelationshipTypeStore", ".relationshiptypestore.db", this.reservedRelTypeRecords(reservedRelTypeRecordsCount, relTypeTokenRecordSize));
        int lastInUseRecordId = this.findLastInUseRecord(relTypeStoreFileName, relTypeTokenRecordSize, 0);
        Assert.assertEquals((long)(reservedRelTypeRecordsCount + relsWithUniqueTypes), (long)lastInUseRecordId);
        this.newImpermanentDb().shutdown();
        lastInUseRecordId = this.findLastInUseRecord(relTypeStoreFileName, relTypeTokenRecordSize, StoreHighIdInflationTest.trailerLength("RelationshipTypeStore"));
        Assert.assertEquals((String)"Unexpected number of inUse records", (long)relsWithUniqueTypes, (long)lastInUseRecordId);
        RelationshipTypeTokenStore relTypeTokenStore = StoreHighIdInflationTest.relTypeTokenStore(this.newImpermanentDb());
        for (int i = 0; i < reservedRelTypeRecordsCount; ++i) {
            Assert.assertEquals((long)(relsWithUniqueTypes + i), (long)relTypeTokenStore.nextId());
        }
    }

    private long getHighestDynamicStringPropertyId(GraphDatabaseAPI db) {
        return ((DataSourceManager)db.getDependencyResolver().resolveDependency(DataSourceManager.class)).getDataSource().getNeoStore().getPropertyStore().getStringStore().getHighestPossibleIdInUse();
    }

    private static RelationshipTypeTokenStore relTypeTokenStore(GraphDatabaseService db) {
        return StoreHighIdInflationTest.neoStoreOf(db).getRelationshipTypeTokenStore();
    }

    private void inflateStore(String trailerTypeDescriptor, String store, ByteBuffer data) throws IOException {
        int trailerLength = StoreHighIdInflationTest.trailerLength(trailerTypeDescriptor);
        File neoStore = new File(this.storeDir, "neostore");
        File storeFile = new File(neoStore.getAbsolutePath() + store);
        EphemeralFileSystemAbstraction fs = this.fsr.get();
        long size = fs.getFileSize(storeFile);
        try (StoreChannel channel = fs.open(storeFile, "rw");){
            channel.position(size - (long)trailerLength);
            channel.write(data);
        }
        fs.deleteFile(new File(storeFile, ".id"));
    }

    private ByteBuffer megabyteWorthOfZeros() {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        while (buffer.hasRemaining()) {
            buffer.put((byte)0);
        }
        buffer.flip();
        return buffer;
    }

    private ByteBuffer reservedRelTypeRecords(int count, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(count * size);
        for (int i = 0; i < count; ++i) {
            buffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
        }
        buffer.flip();
        return buffer;
    }

    private int findLastInUseRecord(String storeFile, int recordSize, int trailerLength) throws IOException {
        try (StoreChannel channel = this.fsr.get().open(new File(this.storeDir, storeFile), "rw");){
            ByteBuffer buffer = ByteBuffer.allocate(recordSize);
            for (long position = channel.size() - (long)trailerLength - (long)recordSize; position > 0L; position -= (long)recordSize) {
                buffer.clear();
                channel.read(buffer, position);
                buffer.flip();
                if (buffer.get() != Record.IN_USE.byteValue()) continue;
                int n = (int)(position / (long)recordSize) + 1;
                return n;
            }
        }
        throw new IllegalStateException("No inUse records found");
    }

    private long createACoupleOfNodes(GraphDatabaseService db, int count) {
        try (Transaction tx = db.beginTx();){
            long last = 0L;
            for (int i = 0; i < count; ++i) {
                Node node = db.createNode();
                node.setProperty("key", (Object)"A very very very loooooooooooooooooooooooooooooooooooooooooooooong string that should spill over into a dynamic record");
                last = node.getId();
            }
            tx.success();
            long l = last;
            return l;
        }
    }

    private static void createLabeledNodesAndRels(int nodeCount, int relCount, GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            int i;
            Node[] nodes = new Node[nodeCount];
            for (i = 0; i < nodeCount; ++i) {
                nodes[i] = db.createNode(new Label[]{DynamicLabel.label((String)("LABEL" + i))});
            }
            for (i = 0; i < relCount; ++i) {
                Node source = nodes[ThreadLocalRandom.current().nextInt(nodes.length)];
                Node target = nodes[ThreadLocalRandom.current().nextInt(nodes.length)];
                source.createRelationshipTo(target, (RelationshipType)DynamicRelationshipType.withName((String)("REL" + i)));
            }
            tx.success();
        }
    }

    private GraphDatabaseService newImpermanentDb() {
        return new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fsr.get()).newImpermanentDatabase(this.storeDir);
    }

    private static int trailerLength(String typeDescriptor) {
        String trailer = CommonAbstractStore.buildTypeDescriptorAndVersion((String)typeDescriptor);
        byte[] trailerBytes = UTF8.encode((String)trailer);
        return trailerBytes.length;
    }
}

