/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.test.EphemeralFileSystemRule;

public class ConfiguringPageCacheFactoryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseConfiguredPageSizeAndFitAsManyPagesAsItCan() throws Throwable {
        Config config = new Config();
        config.applyChanges(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.mapped_memory_page_size.name(), "4096", GraphDatabaseSettings.pagecache_memory.name(), Integer.toString(65536)}));
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory((FileSystemAbstraction)this.fsRule.get(), config, PageCacheTracer.NULL);
        try (PageCache cache = pageCacheFactory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)CoreMatchers.equalTo((Object)4096));
            MatcherAssert.assertThat((Object)cache.maxCachedPages(), (Matcher)CoreMatchers.equalTo((Object)16));
        }
    }
}

