/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.test.EphemeralFileSystemRule;

public class StandalonePageCacheFactoryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Test(timeout=10000L)
    public void mustAutomaticallyStartEvictionThread() throws IOException {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        File file = new File("a");
        fs.create(file);
        try (PageCache cache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);
             PagedFile pf = cache.map(file, 4096);
             PageCursor cursor = pf.io(0L, 2);){
            for (int i = 0; i < 10000; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(42);
            }
        }
    }
}

