/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestStoreRecoverer {
    private final EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();

    @Test
    public void shouldNotWantToRecoverIntactStore() throws Exception {
        File store = null;
        store = this.createIntactStore();
        StoreRecoverer recoverer = new StoreRecoverer((FileSystemAbstraction)this.fileSystem);
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldWantToRecoverBrokenStore() throws Exception {
        File store = this.createIntactStore();
        TestStoreRecoverer.createLogFileForNextVersionWithSomeDataInIt(store, (FileSystemAbstraction)this.fileSystem);
        StoreRecoverer recoverer = new StoreRecoverer((FileSystemAbstraction)this.fileSystem);
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldBeAbleToRecoverBrokenStore() throws Exception {
        File store = this.createIntactStore();
        TestStoreRecoverer.createLogFileForNextVersionWithSomeDataInIt(store, (FileSystemAbstraction)this.fileSystem);
        StoreRecoverer recoverer = new StoreRecoverer((FileSystemAbstraction)this.fileSystem);
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store), (Matcher)CoreMatchers.is((Object)true));
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fileSystem).newImpermanentDatabase(store.getPath()).shutdown();
        Assert.assertThat((Object)recoverer.recoveryNeededAt(store), (Matcher)CoreMatchers.is((Object)false));
    }

    private File createIntactStore() {
        File storeDir = new File("dir");
        this.fileSystem.mkdirs(storeDir);
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fileSystem).newImpermanentDatabase(storeDir.getPath()).shutdown();
        return storeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLogFileForNextVersionWithSomeDataInIt(File store, FileSystemAbstraction fileSystem) throws IOException {
        NeoStoreUtil util = new NeoStoreUtil(store, fileSystem);
        LifeSupport life = new LifeSupport();
        DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(util.getLastCommittedTx(), 0L);
        TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 10);
        PhysicalLogFiles logFiles = new PhysicalLogFiles(store, "neostore.transaction.db", fileSystem);
        LogFile logFile = (LogFile)life.add((Object)new PhysicalLogFile(fileSystem, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)new DeadSimpleLogVersionRepository(util.getLogVersion()), (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), positionCache));
        life.start();
        try {
            PhysicalLogicalTransactionStore transactionStore = new PhysicalLogicalTransactionStore(logFile, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, (KernelHealth)Mockito.mock(KernelHealth.class));
            life.add((Object)transactionStore);
            TransactionAppender appender = transactionStore.getAppender();
            appender.append(TestStoreRecoverer.singleNodeTransaction(), LogAppendEvent.NULL);
        }
        finally {
            life.shutdown();
        }
    }

    private static TransactionRepresentation singleNodeTransaction() {
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(Arrays.asList(TestStoreRecoverer.createNodeCommand()));
        transaction.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, -1);
        return transaction;
    }

    private static Command createNodeCommand() {
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        long id = 0L;
        NodeRecord after = new NodeRecord(id);
        after.setInUse(true);
        nodeCommand.init(new NodeRecord(id), after);
        return nodeCommand;
    }
}

